/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.model.Action;
import hudson.model.Computer;
import jenkins.model.Jenkins;

public class NodeMonitoringAction
implements Action {
    private final Computer computer;
    private final String displayName;
    private final String iconPath;

    public NodeMonitoringAction(Computer computer, String displayName, String iconPath) {
        this.computer = computer;
        this.displayName = displayName;
        this.iconPath = iconPath;
    }

    public Computer getComputer() {
        return this.computer;
    }

    public final String getDisplayName() {
        return this.hasMonitoringPermissions() && this.computer.isOnline() ? this.displayName : null;
    }

    public final String getIconFileName() {
        return this.hasMonitoringPermissions() && this.computer.isOnline() ? this.iconPath : null;
    }

    public String getUrlName() {
        return "monitoring";
    }

    public String getMonitoringUrl() {
        String urlSuffix = this.computer instanceof Jenkins.MasterComputer ? "" : "/nodes/" + this.computer.getName();
        return "../../../monitoring" + urlSuffix;
    }

    protected boolean hasMonitoringPermissions() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins.hasPermission(Jenkins.ADMINISTER);
    }
}

