/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapperHelper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.Counter;

public final class JdbcWrapper {
    public static final JdbcWrapper SINGLETON = new JdbcWrapper(new Counter("sql", "db.png"));
    static final AtomicInteger ACTIVE_CONNECTION_COUNT = new AtomicInteger();
    static final AtomicInteger USED_CONNECTION_COUNT = new AtomicInteger();
    static final AtomicLong TRANSACTION_COUNT = new AtomicLong();
    static final AtomicInteger ACTIVE_THREAD_COUNT = new AtomicInteger();
    static final AtomicInteger RUNNING_BUILD_COUNT = new AtomicInteger();
    static final AtomicInteger BUILD_QUEUE_LENGTH = new AtomicInteger();
    static final AtomicLong BUILD_QUEUE_WAITING_DURATIONS_SUM = new AtomicLong();
    static final Map<Integer, ConnectionInformations> USED_CONNECTION_INFORMATIONS = new ConcurrentHashMap<Integer, ConnectionInformations>();
    private static final int MAX_USED_CONNECTION_INFORMATIONS = 500;
    private final Counter sqlCounter;
    private ServletContext servletContext;
    private boolean connectionInformationsEnabled;
    private boolean jboss;
    private boolean glassfish;
    private boolean weblogic;

    private JdbcWrapper(Counter sqlCounter) {
        assert (sqlCounter != null);
        this.sqlCounter = sqlCounter;
        this.servletContext = null;
        this.connectionInformationsEnabled = Parameters.isSystemActionsEnabled() && !Parameters.isNoDatabase();
    }

    void initServletContext(ServletContext context) {
        assert (context != null);
        this.servletContext = context;
        String serverInfo = this.servletContext.getServerInfo();
        this.jboss = serverInfo.contains("JBoss") || serverInfo.contains("WildFly");
        this.glassfish = serverInfo.contains("GlassFish") || serverInfo.contains("Sun Java System Application Server") || serverInfo.contains("Payara");
        this.weblogic = serverInfo.contains("WebLogic");
        this.connectionInformationsEnabled = Parameters.isSystemActionsEnabled() && !Parameters.isNoDatabase();
    }

    public static int getUsedConnectionCount() {
        return USED_CONNECTION_COUNT.get();
    }

    public static int getActiveConnectionCount() {
        return ACTIVE_CONNECTION_COUNT.get();
    }

    public static long getTransactionCount() {
        return TRANSACTION_COUNT.get();
    }

    public static int getActiveThreadCount() {
        return ACTIVE_THREAD_COUNT.get();
    }

    public static int getRunningBuildCount() {
        return RUNNING_BUILD_COUNT.get();
    }

    public static int getBuildQueueLength() {
        return BUILD_QUEUE_LENGTH.get();
    }

    public static long getBuildQueueWaitingDurationsSum() {
        return BUILD_QUEUE_WAITING_DURATIONS_SUM.get();
    }

    public static List<ConnectionInformations> getConnectionInformationsList() {
        ArrayList<ConnectionInformations> result = new ArrayList<ConnectionInformations>(USED_CONNECTION_INFORMATIONS.values());
        Collections.sort(result, new ConnectionInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    public Counter getSqlCounter() {
        return this.sqlCounter;
    }

    boolean isConnectionInformationsEnabled() {
        return this.connectionInformationsEnabled;
    }

    public static int getMaxConnectionCount() {
        return JdbcWrapperHelper.getMaxConnectionCount();
    }

    public static Map<String, Map<String, Object>> getBasicDataSourceProperties() {
        return JdbcWrapperHelper.getBasicDataSourceProperties();
    }

    public static Map<String, DataSource> getJndiAndSpringDataSources() throws NamingException {
        return JdbcWrapperHelper.getJndiAndSpringDataSources();
    }

    public static void registerSpringDataSource(String name, DataSource dataSource) {
        JdbcWrapperHelper.registerSpringDataSource(name, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doExecute(String requestName, Statement statement, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        assert (requestName != null);
        assert (statement != null);
        assert (method != null);
        if (!this.sqlCounter.isDisplayed() || requestName.startsWith("explain ")) {
            ACTIVE_CONNECTION_COUNT.incrementAndGet();
            try {
                Object object = method.invoke((Object)statement, args);
                return object;
            }
            finally {
                ACTIVE_CONNECTION_COUNT.decrementAndGet();
            }
        }
        long start = System.currentTimeMillis();
        boolean systemError = true;
        try {
            ACTIVE_CONNECTION_COUNT.incrementAndGet();
            this.sqlCounter.bindContext(requestName, requestName, null, -1L, -1L);
            Object result = method.invoke((Object)statement, args);
            systemError = false;
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            int errorCode;
            if (e.getCause() instanceof SQLException && (errorCode = ((SQLException)e.getCause()).getErrorCode()) >= 20000 && errorCode < 30000) {
                systemError = false;
            }
            throw e;
        }
        finally {
            ACTIVE_CONNECTION_COUNT.decrementAndGet();
            long duration = Math.max(System.currentTimeMillis() - start, 0L);
            this.sqlCounter.addRequest(requestName, duration, -1, -1, systemError, -1L);
        }
    }

    boolean rebindDataSources() {
        boolean ok;
        try {
            boolean rewrapDataSources = Parameter.REWRAP_DATASOURCES.getValueAsBoolean();
            if (rewrapDataSources || Parameter.DATASOURCES.getValue() != null) {
                this.stop();
            }
            Map<String, DataSource> jndiDataSources = JdbcWrapperHelper.getJndiDataSources();
            LOG.debug("datasources found in JNDI: " + jndiDataSources.keySet());
            for (Map.Entry<String, DataSource> entry : jndiDataSources.entrySet()) {
                String jndiName = entry.getKey();
                DataSource dataSource = entry.getValue();
                try {
                    if (rewrapDataSources || this.isServerNeedsRewrap(jndiName)) {
                        this.rewrapDataSource(jndiName, dataSource);
                        JdbcWrapperHelper.registerRewrappedDataSource(jndiName, dataSource);
                        continue;
                    }
                    if (JdbcWrapper.isProxyAlready(dataSource)) continue;
                    DataSource dataSourceProxy = this.createDataSourceProxy(jndiName, dataSource);
                    JdbcWrapperHelper.rebindDataSource(this.servletContext, jndiName, dataSource, dataSourceProxy);
                    LOG.debug("datasource rebinded: " + jndiName + " from class " + dataSource.getClass().getName() + " to class " + dataSourceProxy.getClass().getName());
                }
                catch (Throwable t) {
                    LOG.debug("rebinding datasource " + jndiName + " failed, skipping it", t);
                }
            }
            ok = true;
        }
        catch (Throwable t) {
            LOG.debug("rebinding datasources failed, skipping", t);
            ok = false;
        }
        return ok;
    }

    private void rewrapDataSource(String jndiName, DataSource dataSource) throws IllegalAccessException {
        String dataSourceClassName = dataSource.getClass().getName();
        LOG.debug("Datasource needs rewrap: " + jndiName + " of class " + dataSourceClassName);
        String dataSourceRewrappedMessage = "Datasource rewrapped: " + jndiName;
        if (this.isJBossOrGlassfishDataSource(dataSourceClassName)) {
            Object javaxConnectionManager = JdbcWrapperHelper.getFieldValue(dataSource, "cm");
            javaxConnectionManager = this.createJavaxConnectionManagerProxy(javaxConnectionManager);
            JdbcWrapperHelper.setFieldValue(dataSource, "cm", javaxConnectionManager);
            LOG.debug(dataSourceRewrappedMessage);
        } else if (this.isWildfly9DataSource(dataSourceClassName)) {
            Object delegateDataSource = JdbcWrapperHelper.getFieldValue(dataSource, "delegate");
            delegateDataSource = this.createDataSourceProxy((DataSource)delegateDataSource);
            JdbcWrapperHelper.setFieldValue(dataSource, "delegate", delegateDataSource);
            LOG.debug(dataSourceRewrappedMessage);
        } else if (this.weblogic && "weblogic.jdbc.common.internal.RmiDataSource".equals(dataSourceClassName)) {
            this.rewrapWebLogicDataSource(dataSource);
            LOG.debug(dataSourceRewrappedMessage);
        } else if (this.isDbcpDataSource(dataSourceClassName)) {
            this.rewrapBasicDataSource(dataSource);
            LOG.debug(dataSourceRewrappedMessage);
        } else if ("org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource".equals(dataSourceClassName)) {
            this.rewrapTomEEDataSource(dataSource);
            LOG.debug(dataSourceRewrappedMessage);
        } else {
            LOG.info("Datasource can't be rewrapped: " + jndiName + " of class " + dataSourceClassName);
        }
    }

    private boolean isServerNeedsRewrap(String jndiName) {
        return this.glassfish || this.jboss || this.weblogic || jndiName.contains("openejb");
    }

    private boolean isDbcpDataSource(String dataSourceClassName) {
        return "org.apache.tomcat.dbcp.dbcp.BasicDataSource".equals(dataSourceClassName) || "org.apache.tomcat.dbcp.dbcp2.BasicDataSource".equals(dataSourceClassName) || "org.apache.commons.dbcp.BasicDataSource".equals(dataSourceClassName) || "org.apache.commons.dbcp2.BasicDataSource".equals(dataSourceClassName) || "org.apache.openejb.resource.jdbc.BasicManagedDataSource".equals(dataSourceClassName) || "org.apache.openejb.resource.jdbc.BasicDataSource".equals(dataSourceClassName);
    }

    private boolean isJBossOrGlassfishDataSource(String dataSourceClassName) {
        return this.jboss && "org.jboss.resource.adapter.jdbc.WrapperDataSource".equals(dataSourceClassName) || this.jboss && "org.jboss.jca.adapters.jdbc.WrapperDataSource".equals(dataSourceClassName) || this.glassfish && "com.sun.gjc.spi.jdbc40.DataSource40".equals(dataSourceClassName);
    }

    private boolean isWildfly9DataSource(String dataSourceClassName) {
        return this.jboss && "org.jboss.as.connector.subsystems.datasources.WildFlyDataSource".equals(dataSourceClassName);
    }

    private void rewrapWebLogicDataSource(DataSource dataSource) throws IllegalAccessException {
        Object driverInstance;
        Object jdbcCtx = JdbcWrapperHelper.getFieldValue(dataSource, "jdbcCtx");
        if (jdbcCtx != null) {
            jdbcCtx = this.createContextProxy((Context)jdbcCtx);
            JdbcWrapperHelper.setFieldValue(dataSource, "jdbcCtx", jdbcCtx);
        }
        if ((driverInstance = JdbcWrapperHelper.getFieldValue(dataSource, "driverInstance")) != null) {
            driverInstance = this.createDriverProxy((Driver)driverInstance);
            JdbcWrapperHelper.setFieldValue(dataSource, "driverInstance", driverInstance);
        }
    }

    private void rewrapBasicDataSource(DataSource dataSource) throws IllegalAccessException {
        try {
            dataSource.getConnection().close();
        }
        catch (Exception e) {
            LOG.debug(e.toString());
        }
        Object innerDataSource = JdbcWrapperHelper.getFieldValue(dataSource, "dataSource");
        if (innerDataSource != null) {
            innerDataSource = this.createDataSourceProxy((DataSource)innerDataSource);
            JdbcWrapperHelper.setFieldValue(dataSource, "dataSource", innerDataSource);
        }
    }

    private void rewrapTomEEDataSource(DataSource dataSource) throws IllegalAccessException {
        try {
            dataSource.getConnection().close();
        }
        catch (Exception e) {
            LOG.debug(e.toString());
        }
        Object innerDataSource = JdbcWrapperHelper.getFieldValue(dataSource, "delegate");
        if (innerDataSource != null) {
            innerDataSource = this.createDataSourceProxy((DataSource)innerDataSource);
            JdbcWrapperHelper.setFieldValue(dataSource, "delegate", innerDataSource);
        }
    }

    boolean stop() {
        boolean ok;
        try {
            JdbcWrapperHelper.rebindInitialDataSources(this.servletContext);
            Map<String, DataSource> rewrappedDataSources = JdbcWrapperHelper.getRewrappedDataSources();
            for (Map.Entry<String, DataSource> entry : rewrappedDataSources.entrySet()) {
                String jndiName = entry.getKey();
                DataSource dataSource = entry.getValue();
                this.unwrapDataSource(jndiName, dataSource);
            }
            rewrappedDataSources.clear();
            JdbcWrapperHelper.clearProxyCache();
            ok = true;
        }
        catch (Throwable t) {
            LOG.debug("rebinding initial datasources failed, skipping", t);
            ok = false;
        }
        return ok;
    }

    private void unwrapDataSource(String jndiName, DataSource dataSource) throws IllegalAccessException {
        String dataSourceClassName = dataSource.getClass().getName();
        LOG.debug("Datasource needs unwrap: " + jndiName + " of class " + dataSourceClassName);
        String dataSourceUnwrappedMessage = "Datasource unwrapped: " + jndiName;
        if (this.isJBossOrGlassfishDataSource(dataSourceClassName)) {
            this.unwrap(dataSource, "cm", dataSourceUnwrappedMessage);
        } else if (this.isWildfly9DataSource(dataSourceClassName)) {
            this.unwrap(dataSource, "delegate", dataSourceUnwrappedMessage);
        } else if (this.weblogic && "weblogic.jdbc.common.internal.RmiDataSource".equals(dataSourceClassName)) {
            this.unwrap(dataSource, "jdbcCtx", dataSourceUnwrappedMessage);
            this.unwrap(dataSource, "driverInstance", dataSourceUnwrappedMessage);
        } else if (this.isDbcpDataSource(dataSourceClassName)) {
            this.unwrap(dataSource, "dataSource", dataSourceUnwrappedMessage);
        }
    }

    private void unwrap(Object parentObject, String fieldName, String unwrappedMessage) throws IllegalAccessException {
        InvocationHandler invocationHandler;
        Object proxy = JdbcWrapperHelper.getFieldValue(parentObject, fieldName);
        if (Proxy.isProxyClass(proxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(proxy)) instanceof DelegatingInvocationHandler && (invocationHandler = ((DelegatingInvocationHandler)invocationHandler).getDelegate()) instanceof AbstractInvocationHandler) {
            Object proxiedObject = ((AbstractInvocationHandler)invocationHandler).getProxiedObject();
            JdbcWrapperHelper.setFieldValue(parentObject, fieldName, proxiedObject);
            LOG.debug(unwrappedMessage);
        }
    }

    Context createContextProxy(final Context context) {
        assert (context != null);
        AbstractInvocationHandler<Context> invocationHandler = new AbstractInvocationHandler<Context>(context){
            private static final long serialVersionUID = 1L;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)context, args);
                if (result instanceof DataSource) {
                    result = JdbcWrapper.this.createDataSourceProxy((DataSource)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(context, invocationHandler);
    }

    private Driver createDriverProxy(final Driver driver) {
        assert (driver != null);
        AbstractInvocationHandler<Driver> invocationHandler = new AbstractInvocationHandler<Driver>(driver){
            private static final long serialVersionUID = 1L;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)driver, args);
                if (result instanceof Connection) {
                    result = JdbcWrapper.this.createConnectionProxy((Connection)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(driver, invocationHandler);
    }

    private Object createJavaxConnectionManagerProxy(Object javaxConnectionManager) {
        assert (javaxConnectionManager != null);
        ConnectionManagerInvocationHandler invocationHandler = new ConnectionManagerInvocationHandler(javaxConnectionManager);
        return JdbcWrapper.createProxy(javaxConnectionManager, invocationHandler);
    }

    void rewrapConnection(Connection connection) throws IllegalAccessException {
        assert (connection != null);
        if (this.jboss && connection.getClass().getSimpleName().startsWith("WrappedConnection")) {
            Object baseWrapperManagedConnection = JdbcWrapperHelper.getFieldValue(connection, "mc");
            String conFieldName = "con";
            Connection con = (Connection)JdbcWrapperHelper.getFieldValue(baseWrapperManagedConnection, "con");
            if (!JdbcWrapper.isProxyAlready(con)) {
                con = this.createConnectionProxy(con);
                JdbcWrapperHelper.setFieldValue(baseWrapperManagedConnection, "con", con);
            }
        } else if (this.glassfish && ("com.sun.gjc.spi.jdbc40.ConnectionHolder40".equals(connection.getClass().getName()) || "com.sun.gjc.spi.jdbc40.ConnectionWrapper40".equals(connection.getClass().getName()))) {
            String conFieldName = "con";
            Connection con = (Connection)JdbcWrapperHelper.getFieldValue(connection, "con");
            if (!JdbcWrapper.isProxyAlready(con)) {
                con = this.createConnectionProxy(con);
                JdbcWrapperHelper.setFieldValue(connection, "con", con);
            }
        }
    }

    public DataSource createDataSourceProxy(DataSource dataSource) {
        return this.createDataSourceProxy(null, dataSource);
    }

    public DataSource createDataSourceProxy(String name, final DataSource dataSource) {
        assert (dataSource != null);
        JdbcWrapperHelper.pullDataSourceProperties(name, dataSource);
        AbstractInvocationHandler<DataSource> invocationHandler = new AbstractInvocationHandler<DataSource>(dataSource){
            private static final long serialVersionUID = 1L;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)dataSource, args);
                if (result instanceof Connection) {
                    result = JdbcWrapper.this.createConnectionProxy((Connection)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(dataSource, invocationHandler);
    }

    Connection createConnectionProxyOrRewrapIfJBossOrGlassfish(Connection connection) throws IllegalAccessException {
        if (this.jboss || this.glassfish) {
            this.rewrapConnection(connection);
            return connection;
        }
        return this.createConnectionProxy(connection);
    }

    public Connection createConnectionProxy(Connection connection) {
        assert (connection != null);
        if (JdbcWrapper.isMonitoringDisabled()) {
            return connection;
        }
        ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(connection);
        Connection result = JdbcWrapper.createProxy(connection, invocationHandler);
        if (result != connection) {
            invocationHandler.init();
        }
        return result;
    }

    boolean isSqlMonitoringDisabled() {
        return JdbcWrapper.isMonitoringDisabled() || !this.sqlCounter.isDisplayed();
    }

    private static boolean isMonitoringDisabled() {
        return Parameter.DISABLED.getValueAsBoolean();
    }

    Statement createStatementProxy(String query, Statement statement) {
        assert (statement != null);
        StatementInvocationHandler invocationHandler = new StatementInvocationHandler(query, statement);
        return JdbcWrapper.createProxy(statement, invocationHandler);
    }

    static boolean isEqualsMethod(Object methodName, Object[] args) {
        return "equals" == methodName && args != null && args.length == 1;
    }

    static boolean isHashCodeMethod(Object methodName, Object[] args) {
        return "hashCode" == methodName && (args == null || args.length == 0);
    }

    static <T> T createProxy(T object, InvocationHandler invocationHandler) {
        return JdbcWrapper.createProxy(object, invocationHandler, null);
    }

    static <T> T createProxy(T object, InvocationHandler invocationHandler, List<Class<?>> interfaces) {
        if (JdbcWrapper.isProxyAlready(object)) {
            return object;
        }
        DelegatingInvocationHandler ih = new DelegatingInvocationHandler(invocationHandler);
        return JdbcWrapperHelper.createProxy(object, ih, interfaces);
    }

    static boolean isProxyAlready(Object object) {
        return Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object).getClass().getName().equals(DelegatingInvocationHandler.class.getName());
    }

    private static class DelegatingInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 7515240588169084785L;
        private final InvocationHandler delegate;

        DelegatingInvocationHandler(InvocationHandler delegate) {
            this.delegate = delegate;
        }

        InvocationHandler getDelegate() {
            return this.delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.delegate.invoke(proxy, method, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
        }
    }

    private static abstract class AbstractInvocationHandler<T>
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T proxiedObject;

        AbstractInvocationHandler(T proxiedObject) {
            this.proxiedObject = proxiedObject;
        }

        T getProxiedObject() {
            return this.proxiedObject;
        }
    }

    private static class ConnectionManagerInvocationHandler
    extends AbstractInvocationHandler<Object> {
        private static final long serialVersionUID = 1L;

        ConnectionManagerInvocationHandler(Object javaxConnectionManager) {
            super(javaxConnectionManager);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke(this.getProxiedObject(), args);
            if (result instanceof Connection) {
                return SINGLETON.createConnectionProxyOrRewrapIfJBossOrGlassfish((Connection)result);
            }
            return result;
        }
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        private boolean alreadyClosed;

        ConnectionInvocationHandler(Connection connection) {
            assert (connection != null);
            this.connection = connection;
        }

        void init() {
            if (JdbcWrapper.this.isConnectionInformationsEnabled() && USED_CONNECTION_INFORMATIONS.size() < 500) {
                USED_CONNECTION_INFORMATIONS.put(ConnectionInformations.getUniqueIdOfConnection(this.connection), new ConnectionInformations());
            }
            USED_CONNECTION_COUNT.incrementAndGet();
            TRANSACTION_COUNT.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (JdbcWrapper.isEqualsMethod(methodName, args)) {
                return this.areConnectionsEquals(args[0]);
            }
            if (JdbcWrapper.isHashCodeMethod(methodName, args)) {
                return this.connection.hashCode();
            }
            try {
                Object result = method.invoke((Object)this.connection, args);
                if (result instanceof Statement) {
                    String requestName = "prepareStatement".equals(methodName) || "prepareCall".equals(methodName) ? (String)args[0] : null;
                    result = JdbcWrapper.this.createStatementProxy(requestName, (Statement)result);
                }
                Object object = result;
                return object;
            }
            finally {
                if ("close".equals(methodName) && !this.alreadyClosed) {
                    USED_CONNECTION_COUNT.decrementAndGet();
                    USED_CONNECTION_INFORMATIONS.remove(ConnectionInformations.getUniqueIdOfConnection(this.connection));
                    this.alreadyClosed = true;
                }
            }
        }

        private boolean areConnectionsEquals(Object object) {
            DelegatingInvocationHandler d;
            InvocationHandler invocationHandler;
            if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof DelegatingInvocationHandler && (d = (DelegatingInvocationHandler)invocationHandler).getDelegate() instanceof ConnectionInvocationHandler) {
                ConnectionInvocationHandler c = (ConnectionInvocationHandler)d.getDelegate();
                return this.connection.equals(c.connection);
            }
            return this.connection.equals(object);
        }
    }

    private class StatementInvocationHandler
    implements InvocationHandler {
        private String requestName;
        private final Statement statement;

        StatementInvocationHandler(String query, Statement statement) {
            assert (statement != null);
            this.requestName = query;
            this.statement = statement;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (JdbcWrapper.isEqualsMethod(methodName, args)) {
                return this.statement.equals(args[0]);
            }
            if (JdbcWrapper.isHashCodeMethod(methodName, args)) {
                return this.statement.hashCode();
            }
            if (methodName.startsWith("execute")) {
                if (this.isFirstArgAString(args)) {
                    this.requestName = (String)args[0];
                } else if (("executeBatch".equals(methodName) || "executeLargeBatch".equals(methodName)) && this.requestName != null && !this.requestName.startsWith("/* BATCH */ ")) {
                    this.requestName = "/* BATCH */ " + this.requestName;
                }
                this.requestName = String.valueOf(this.requestName);
                return JdbcWrapper.this.doExecute(this.requestName, this.statement, method, args);
            }
            if ("addBatch".equals(methodName) && this.isFirstArgAString(args)) {
                this.requestName = (String)args[0];
            }
            return method.invoke((Object)this.statement, args);
        }

        private boolean isFirstArgAString(Object[] args) {
            return args != null && args.length > 0 && args[0] instanceof String;
        }
    }

    static final class ConnectionInformationsComparator
    implements Comparator<ConnectionInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ConnectionInformationsComparator() {
        }

        @Override
        public int compare(ConnectionInformations connection1, ConnectionInformations connection2) {
            return connection1.getOpeningDate().compareTo(connection2.getOpeningDate());
        }
    }
}

