/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.NodesCollector;
import net.bull.javamelody.NodesController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.PluginMonitoringFilter;

public class HudsonMonitoringFilter
extends PluginMonitoringFilter {
    private static final boolean PLUGIN_AUTHENTICATION_DISABLED = Parameter.PLUGIN_AUTHENTICATION_DISABLED.getValueAsBoolean();
    private NodesCollector nodesCollector;

    public String getApplicationType() {
        return "Jenkins";
    }

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.nodesCollector = new NodesCollector((MonitoringFilter)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || this.getNodesCollector().isMonitoringDisabled()) {
            super.doFilter(request, response, chain);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        String monitoringUrl = this.getMonitoringUrl(httpRequest);
        String monitoringSlavesUrl = monitoringUrl + "/nodes";
        if (requestURI.equals(monitoringUrl) || requestURI.startsWith(monitoringSlavesUrl)) {
            if (this.isRumMonitoring(httpRequest, httpResponse)) {
                return;
            }
            if (!PLUGIN_AUTHENTICATION_DISABLED) {
                Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            }
            if (this.hasInvalidParameters(request)) {
                httpResponse.sendError(400);
                return;
            }
        }
        if (requestURI.startsWith(monitoringSlavesUrl)) {
            String nodeName = requestURI.equals(monitoringSlavesUrl) ? null : URLDecoder.decode(requestURI.substring(monitoringSlavesUrl.length()).replace("/", ""), "UTF-8");
            this.doMonitoring(httpRequest, httpResponse, nodeName);
            return;
        }
        try {
            super.doFilter(request, response, chain);
        }
        finally {
            this.putUserInfoInSession(httpRequest);
        }
    }

    private boolean hasInvalidParameters(ServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            for (String value : request.getParameterValues(parameterName)) {
                if (value.indexOf(34) == -1 && value.indexOf(39) == -1 && value.indexOf(60) == -1 && value.indexOf(38) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private void putUserInfoInSession(HttpServletRequest httpRequest) {
        String remoteUser;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        if (session.getAttribute("javamelody.remoteUser") == null && (remoteUser = Jenkins.getAuthentication().getName()) != null && !"anonymous".equals(remoteUser)) {
            session.setAttribute("javamelody.remoteUser", (Object)remoteUser);
        }
    }

    private void doMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String nodeName) throws IOException {
        if (NodesController.isJavaInformationsNeeded(httpRequest)) {
            this.getNodesCollector().collectWithoutErrorsNow();
        }
        NodesController nodesController = new NodesController(this.getNodesCollector(), nodeName);
        nodesController.doMonitoring(httpRequest, httpResponse);
    }

    NodesCollector getNodesCollector() {
        return this.nodesCollector;
    }
}

