/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;

abstract class DataImporter {
    DataImporter() {
    }

    abstract String getVersion() throws RrdException, IOException;

    abstract long getLastUpdateTime() throws RrdException, IOException;

    abstract long getStep() throws RrdException, IOException;

    abstract int getDsCount() throws RrdException, IOException;

    abstract int getArcCount() throws RrdException, IOException;

    abstract String getDsName(int var1) throws RrdException, IOException;

    abstract String getDsType(int var1) throws RrdException, IOException;

    abstract long getHeartbeat(int var1) throws RrdException, IOException;

    abstract double getMinValue(int var1) throws RrdException, IOException;

    abstract double getMaxValue(int var1) throws RrdException, IOException;

    abstract double getLastValue(int var1) throws RrdException, IOException;

    abstract double getAccumValue(int var1) throws RrdException, IOException;

    abstract long getNanSeconds(int var1) throws RrdException, IOException;

    abstract String getConsolFun(int var1) throws RrdException, IOException;

    abstract double getXff(int var1) throws RrdException, IOException;

    abstract int getSteps(int var1) throws RrdException, IOException;

    abstract int getRows(int var1) throws RrdException, IOException;

    abstract double getStateAccumValue(int var1, int var2) throws RrdException, IOException;

    abstract int getStateNanSteps(int var1, int var2) throws RrdException, IOException;

    abstract double[] getValues(int var1, int var2) throws RrdException, IOException;

    long getEstimatedSize() throws RrdException, IOException {
        int dsCount = this.getDsCount();
        int arcCount = this.getArcCount();
        int rowCount = 0;
        int i = 0;
        while (i < arcCount) {
            rowCount += this.getRows(i);
            ++i;
        }
        return RrdDef.calculateSize(dsCount, arcCount, rowCount);
    }

    void release() throws RrdException, IOException {
    }
}

