/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlJndiTreeReport
extends HtmlAbstractReport {
    private final List<JndiBinding> jndiBindings;
    private final String path;

    HtmlJndiTreeReport(List<JndiBinding> jndiBindings, String path, Writer writer) {
        super(writer);
        assert (jndiBindings != null);
        this.jndiBindings = jndiBindings;
        this.path = JndiBinding.normalizePath(path);
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        String title = this.path.isEmpty() ? HtmlJndiTreeReport.getString("Arbre_JNDI") : HtmlJndiTreeReport.getFormattedString("Arbre_JNDI_pour_contexte", HtmlJndiTreeReport.htmlEncode(this.path));
        this.writeTitle("jndi.png", title);
        this.writeTable();
    }

    private void writeTable() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlJndiTreeReport.getString("Arbre_JNDI"));
        this.write("<th>#Nom#</th><th>#Type#</th><th>#Value#</th>");
        for (JndiBinding binding : this.jndiBindings) {
            table.nextRow();
            this.writeBinding(binding);
        }
        table.endTable();
    }

    private void writeBinding(JndiBinding binding) throws IOException {
        this.write("<td>");
        String name = binding.getName();
        String className = binding.getClassName();
        String contextPath = binding.getContextPath();
        String value = binding.getValue();
        if (contextPath != null) {
            this.writeDirectly("<a href=\"?part=jndi&amp;path=" + HtmlJndiTreeReport.urlEncode(contextPath) + "\">");
            this.writeDirectly("<img width='16' height='16' src='?resource=folder.png' alt='" + HtmlJndiTreeReport.urlEncode(name) + "' />&nbsp;");
            this.writeDirectly(HtmlJndiTreeReport.htmlEncode(name));
            this.writeDirectly("</a>");
        } else {
            this.writeDirectly(HtmlJndiTreeReport.htmlEncode(name));
        }
        this.write("</td>");
        this.write("<td>");
        this.writeDirectly(className != null ? HtmlJndiTreeReport.htmlEncode(className) : "&nbsp;");
        this.write("</td>");
        this.write("<td>");
        this.writeDirectly(value != null ? HtmlJndiTreeReport.htmlEncodeButNotSpace(value) : "&nbsp;");
        this.write("</td>");
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeDirectly("<a href='?#systeminfo'>");
        this.writeln("<img src='?resource=action_home.png' alt='#Page_principale#'/> #Page_principale#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path) + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlJndiTreeReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=jndi&amp;path=" + HtmlJndiTreeReport.htmlEncode(this.path) + "&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }
}

