/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import org.jrobin.core.jrrd.RRDFile;

public class CDPStatusBlock {
    long offset;
    long size;
    int unknownDatapoints;
    double value;

    CDPStatusBlock(RRDFile file) throws IOException {
        this.offset = file.getFilePointer();
        this.value = file.readDouble();
        this.unknownDatapoints = file.readInt();
        file.skipBytes(68);
        this.size = file.getFilePointer() - this.offset;
    }

    public int getUnknownDatapoints() {
        return this.unknownDatapoints;
    }

    public double getValue() {
        return this.value;
    }

    void toXml(PrintStream s) {
        s.print("\t\t\t<ds><value> ");
        s.print(this.value);
        s.print(" </value>  <unknown_datapoints> ");
        s.print(this.unknownDatapoints);
        s.println(" </unknown_datapoints></ds>");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[CDPStatusBlock: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", unknownDatapoints=");
        sb.append(this.unknownDatapoints);
        sb.append(", value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

