/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.JobInformations;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzAdapter {
    private static final boolean QUARTZ_2 = QuartzAdapter.isQuartz2();
    private static final QuartzAdapter SINGLETON = QuartzAdapter.createSingleton();

    protected QuartzAdapter() {
    }

    public static QuartzAdapter getSingleton() {
        return SINGLETON;
    }

    private static boolean isQuartz2() {
        try {
            Class.forName("org.quartz.JobKey");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static QuartzAdapter createSingleton() {
        if (QUARTZ_2) {
            try {
                Class<?> clazz = Class.forName("net.bull.javamelody.internal.model.Quartz2Adapter");
                return (QuartzAdapter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new QuartzAdapter();
    }

    String getJobName(JobDetail jobDetail) {
        return jobDetail.getName();
    }

    String getJobGroup(JobDetail jobDetail) {
        return jobDetail.getGroup();
    }

    public String getJobFullName(JobDetail jobDetail) {
        return this.getJobGroup(jobDetail) + '.' + this.getJobName(jobDetail);
    }

    String getJobDescription(JobDetail jobDetail) {
        return jobDetail.getDescription();
    }

    Class<?> getJobClass(JobDetail jobDetail) {
        return jobDetail.getJobClass();
    }

    Date getTriggerPreviousFireTime(Trigger trigger) {
        return trigger.getPreviousFireTime();
    }

    Date getTriggerNextFireTime(Trigger trigger) {
        return trigger.getNextFireTime();
    }

    String getCronTriggerExpression(CronTrigger trigger) {
        return trigger.getCronExpression();
    }

    long getSimpleTriggerRepeatInterval(SimpleTrigger trigger) {
        return trigger.getRepeatInterval();
    }

    public JobDetail getContextJobDetail(JobExecutionContext context) {
        return context.getJobDetail();
    }

    Date getContextFireTime(JobExecutionContext context) {
        return context.getFireTime();
    }

    public void addGlobalJobListener(JobListener jobGlobalListener) throws SchedulerException {
        Scheduler defaultScheduler;
        if (Parameter.QUARTZ_DEFAULT_LISTENER_DISABLED.getValueAsBoolean()) {
            defaultScheduler = null;
            LOG.debug("Initialization of Quartz default listener has been disabled");
        } else {
            defaultScheduler = StdSchedulerFactory.getDefaultScheduler();
            defaultScheduler.addGlobalJobListener(jobGlobalListener);
        }
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            if (scheduler == defaultScheduler) continue;
            scheduler.addGlobalJobListener(jobGlobalListener);
        }
    }

    public void removeGlobalJobListener(Class<? extends JobListener> jobListenerClass) throws SchedulerException {
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            List globalJobListeners = scheduler.getGlobalJobListeners();
            for (JobListener jobListener : new ArrayList(globalJobListeners)) {
                if (!jobListenerClass.isInstance(jobListener)) continue;
                try {
                    scheduler.removeGlobalJobListener(jobListener);
                }
                catch (NoSuchMethodError e1) {
                    try {
                        Class<?> schedulerClass = scheduler.getClass();
                        schedulerClass.getMethod("removeGlobalJobListener", String.class).invoke((Object)scheduler, jobListener.getName());
                    }
                    catch (Exception e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
            }
        }
    }

    List<JobDetail> getAllJobsOfScheduler(Scheduler scheduler) throws SchedulerException {
        ArrayList<JobDetail> result = new ArrayList<JobDetail>();
        for (String jobGroupName : scheduler.getJobGroupNames()) {
            for (String jobName : scheduler.getJobNames(jobGroupName)) {
                try {
                    JobDetail jobDetail = scheduler.getJobDetail(jobName, jobGroupName);
                    if (jobDetail == null) continue;
                    result.add(jobDetail);
                }
                catch (Exception e) {
                    LOG.debug(e.toString(), e);
                }
            }
        }
        return result;
    }

    List<Trigger> getTriggersOfJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        return Arrays.asList(scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup()));
    }

    boolean isTriggerPaused(Trigger trigger, Scheduler scheduler) throws SchedulerException {
        return scheduler.getTriggerState(trigger.getName(), trigger.getGroup()) == 1;
    }

    void pauseJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.pauseJob(jobDetail.getName(), jobDetail.getGroup());
    }

    void resumeJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.resumeJob(jobDetail.getName(), jobDetail.getGroup());
    }
}

