/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Range;

public class JnlpPage {
    public static final String JNLP_PREFIX = "jnlp.";
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final String codebase;
    private final String cookies;
    private final Range range;
    private final Writer writer;

    JnlpPage(Collector collector, CollectorServer collectorServer, String codebase, String cookies, Range range, Writer writer) {
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.codebase = codebase;
        this.cookies = cookies;
        this.range = range;
        this.writer = writer;
    }

    void toJnlp() throws IOException {
        this.println("<jnlp spec='1.0+' codebase='" + this.codebase + "'>");
        this.println("   <information>");
        this.println("      <title>JavaMelody</title>");
        this.println("      <vendor>JavaMelody</vendor>");
        this.println("      <description>Monitoring</description>");
        this.println("      <icon href='" + this.codebase + "?resource=systemmonitor.png'/>");
        this.println("      <offline-allowed />");
        this.println("   </information>");
        this.println("   <security> <all-permissions/> </security>");
        this.println("   <update check='always' policy='always'/>");
        this.println("   <resources>");
        this.println("      <j2se version='1.7+' max-heap-size='300m'/>");
        String jarFileUrl = JnlpPage.getJarFileUrl();
        this.println("      <jar href='" + jarFileUrl + "' />");
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("javamelody.application", this.collector.getApplication());
        properties.put("javamelody.collectorServer", this.collectorServer != null);
        String url = this.collectorServer == null ? this.codebase + "?format=serialized" : this.codebase + "?format=serialized&application=" + this.collector.getApplication();
        properties.put("javamelody.url", url);
        properties.put("javamelody.range", this.range.getValue());
        properties.put("javamelody.locale", I18N.getCurrentLocale());
        for (Parameter parameter : Parameter.values()) {
            if (parameter.getValue() == null || parameter == Parameter.ADMIN_EMAILS) continue;
            properties.put("javamelody." + parameter.getCode(), parameter.getValue());
        }
        if (this.cookies != null) {
            properties.put("cookies", this.cookies);
        }
        for (Map.Entry entry : properties.entrySet()) {
            this.println("      <property name='jnlp." + (String)entry.getKey() + "' value='" + entry.getValue() + "'/>");
        }
        this.println("   </resources>");
        this.println("   <application-desc main-class='net.bull.javamelody.Main' />");
        this.println("</jnlp>");
    }

    private void println(String string) throws IOException {
        this.writer.write(string);
        this.writer.write(10);
    }

    private static String getJarFileUrl() {
        String jarFileUrl = Parameter.JAVAMELODY_SWING_URL.getValue() != null ? Parameter.JAVAMELODY_SWING_URL.getValue() : "https://github.com/javamelody/javamelody/releases/download/javamelody-core-1.49.0/javamelody-swing-1.68.0.jar";
        return jarFileUrl;
    }
}

