/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.model.MetricsPublisher;

class CloudWatch
extends MetricsPublisher {
    private final String cloudWatchNamespace;
    private final AmazonCloudWatch awsCloudWatch;
    private final String prefix;
    private final List<Dimension> dimensions = new ArrayList<Dimension>();
    private final List<MetricDatum> buffer = new ArrayList<MetricDatum>();
    private long lastTime;
    private Date lastTimestamp;

    CloudWatch(AmazonCloudWatch cloudWatch, String cloudWatchNamespace, String prefix, String application, String hostName) {
        assert (cloudWatch != null);
        assert (cloudWatchNamespace != null && !cloudWatchNamespace.startsWith("AWS/") && cloudWatchNamespace.length() > 0 && cloudWatchNamespace.length() <= 255);
        assert (prefix != null);
        assert (application == null || application.length() >= 1 && application.length() <= 255);
        assert (hostName == null || hostName.length() >= 1 && hostName.length() <= 255);
        this.awsCloudWatch = cloudWatch;
        this.cloudWatchNamespace = cloudWatchNamespace;
        this.prefix = prefix;
        if (application != null) {
            this.dimensions.add(new Dimension().withName("application").withValue(application));
        }
        if (hostName != null) {
            this.dimensions.add(new Dimension().withName("hostname").withValue(hostName));
        }
    }

    CloudWatch(String cloudWatchNamespace, String prefix, String application, String hostName) {
        this(AmazonCloudWatchClientBuilder.defaultClient(), cloudWatchNamespace, prefix, application, hostName);
    }

    static CloudWatch getInstance(String contextPath, String hostName) {
        String cloudWatchNamespace = Parameter.CLOUDWATCH_NAMESPACE.getValue();
        if (cloudWatchNamespace != null) {
            assert (contextPath != null);
            assert (hostName != null);
            if (cloudWatchNamespace.startsWith("AWS/")) {
                throw new IllegalArgumentException("CloudWatch namespaces starting with \"AWS/\" are reserved for use by AWS products.");
            }
            String prefix = "javamelody.";
            String application = contextPath;
            if (application.isEmpty()) {
                application = "/";
            }
            return new CloudWatch(cloudWatchNamespace, "javamelody.", application, hostName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addValue(String metric, double value) {
        assert (metric != null);
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (this.lastTime != timeInSeconds) {
            this.lastTimestamp = new Date();
            this.lastTime = timeInSeconds;
        }
        MetricDatum metricDatum = new MetricDatum().withMetricName(this.prefix + metric).withDimensions(this.dimensions).withTimestamp(this.lastTimestamp).withValue(Double.valueOf(value));
        List<MetricDatum> list = this.buffer;
        synchronized (list) {
            this.buffer.add(metricDatum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void send() throws IOException {
        ArrayList<MetricDatum> datumList;
        List<MetricDatum> list = this.buffer;
        synchronized (list) {
            datumList = new ArrayList<MetricDatum>(this.buffer);
            this.buffer.clear();
        }
        PutMetricDataRequest request = new PutMetricDataRequest().withNamespace(this.cloudWatchNamespace).withMetricData(datumList);
        try {
            this.awsCloudWatch.putMetricData(request);
        }
        catch (Exception e) {
            throw new IOException("Error connecting to AWS CloudWatch", e);
        }
    }

    @Override
    void stop() {
        this.awsCloudWatch.shutdown();
    }
}

