/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.RemoteCollector;
import net.bull.javamelody.SamplingProfiler;
import net.bull.javamelody.SerializableController;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Logger;

class CollectorController {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final String COOKIE_NAME = "javamelody.application";
    private static final boolean CSRF_PROTECTION_ENABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.CSRF_PROTECTION_ENABLED));
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final CollectorServer collectorServer;

    CollectorController(CollectorServer collectorServer) {
        assert (collectorServer != null);
        this.collectorServer = collectorServer;
    }

    void addCollectorApplication(String appName, String appUrls) throws IOException {
        File file = Parameters.getCollectorApplicationsFile();
        if (file.exists() && !file.canWrite()) {
            throw new IllegalStateException("applications should be added or removed in the applications.properties file, because the user is not allowed to write: " + file);
        }
        List<URL> urls = Parameters.parseUrl(appUrls);
        this.collectorServer.addCollectorApplication(appName, urls);
    }

    void doMonitoring(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        try {
            String actionParameter = req.getParameter("action");
            if (actionParameter != null) {
                if (CSRF_PROTECTION_ENABLED) {
                    MonitoringController.checkCsrfToken(req);
                }
                if ("remove_application".equalsIgnoreCase(actionParameter)) {
                    this.collectorServer.removeCollectorApplication(application);
                    LOGGER.info((Object)("monitored application removed: " + application));
                    String messageForReport = I18N.getFormattedString("application_enlevee", application);
                    CollectorController.showAlertAndRedirectTo(resp, messageForReport, "?");
                    return;
                }
                Collector collector = this.getCollectorByApplication(application);
                MonitoringController monitoringController = new MonitoringController(collector, this.collectorServer);
                Action action = Action.valueOfIgnoreCase(actionParameter);
                String messageForReport = action != Action.CLEAR_COUNTER && action != Action.MAIL_TEST && action != Action.PURGE_OBSOLETE_FILES ? this.forwardActionAndUpdateData(req, application) : monitoringController.executeActionIfNeeded(req);
                if (TransportFormat.isATransportFormat(req.getParameter("format"))) {
                    SerializableController serializableController = new SerializableController(collector);
                    Range range = serializableController.getRangeForSerializable(req);
                    ArrayList serializable = new ArrayList();
                    List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
                    serializable.addAll((List)((Object)serializableController.createDefaultSerializable(javaInformationsList, range, messageForReport)));
                    monitoringController.doCompressedSerializable(req, resp, serializable);
                } else {
                    this.writeMessage(req, resp, application, messageForReport);
                }
                return;
            }
            this.doReport(req, resp, application);
        }
        catch (RuntimeException e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
        catch (Exception e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
    }

    private void doReport(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException, ServletException {
        Collector collector = this.getCollectorByApplication(application);
        MonitoringController monitoringController = new MonitoringController(collector, this.collectorServer);
        String partParameter = req.getParameter("part");
        String formatParameter = req.getParameter("format");
        if (req.getParameter("jmxValue") != null) {
            this.doJmxValue(req, resp, application, req.getParameter("jmxValue"));
        } else if (TransportFormat.isATransportFormat(formatParameter)) {
            this.doCompressedSerializable(req, resp, application, monitoringController);
        } else if (partParameter == null || "pdf".equalsIgnoreCase(formatParameter)) {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        } else {
            this.doCompressedPart(req, resp, application, monitoringController, partParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedPart(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String application, MonitoringController monitoringController, String partParameter) throws IOException, ServletException {
        if (MonitoringController.isCompressionSupported(httpRequest)) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
            try {
                this.doPart(httpRequest, (HttpServletResponse)wrappedResponse, application, monitoringController, partParameter);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            this.doPart(httpRequest, httpResponse, application, monitoringController, partParameter);
        }
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController, String partParameter) throws IOException, ServletException {
        if ("web.xml".equalsIgnoreCase(partParameter) || "pom.xml".equalsIgnoreCase(partParameter)) {
            CollectorController.noCache(resp);
            this.doProxy(req, resp, application, partParameter);
        } else if ("source".equalsIgnoreCase(partParameter)) {
            CollectorController.noCache(resp);
            this.doProxy(req, resp, application, partParameter + '&' + "class" + '=' + req.getParameter("class"));
        } else if ("connections".equalsIgnoreCase(partParameter)) {
            this.doMultiHtmlProxy(req, resp, application, "connections", "Connexions_jdbc_ouvertes", "connexions_intro", "db.png");
        } else {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        }
    }

    private void doJmxValue(HttpServletRequest req, HttpServletResponse resp, String application, String jmxValueParameter) throws IOException {
        CollectorController.noCache(resp);
        resp.setContentType("text/plain");
        boolean first = true;
        for (URL url : CollectorController.getUrlsByApplication(application)) {
            if (first) {
                first = false;
            } else {
                resp.getOutputStream().write(124);
                resp.getOutputStream().write(124);
            }
            URL proxyUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "").replace(TransportFormat.XML.getCode(), "") + '&' + "jmxValue" + '=' + jmxValueParameter);
            new LabradorRetriever(proxyUrl).copyTo(req, resp);
        }
        resp.getOutputStream().close();
    }

    private void doProxy(HttpServletRequest req, HttpServletResponse resp, String application, String partParameter) throws IOException {
        URL url = CollectorController.getUrlsByApplication(application).get(0);
        URL proxyUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "htmlbody").replace(TransportFormat.XML.getCode(), "htmlbody") + '&' + "part" + '=' + partParameter);
        new LabradorRetriever(proxyUrl).copyTo(req, resp);
    }

    private void doMultiHtmlProxy(HttpServletRequest req, HttpServletResponse resp, String application, String partParameter, String titleKey, String introductionKey, String iconName) throws IOException {
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        htmlReport.writeHtmlHeader();
        writer.write("<div class='noPrint'>");
        I18N.writelnTo("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", writer);
        writer.write("<a href='?part=");
        writer.write(partParameter);
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        if (introductionKey != null) {
            writer.write("<br/>");
            writer.write(I18N.getString(introductionKey));
        }
        String title = I18N.getString(titleKey);
        for (URL url : CollectorController.getUrlsByApplication(application)) {
            String htmlTitle = "<h3 class='chapterTitle'><img src='?resource=" + iconName + "' alt='" + title + "'/>&nbsp;" + title + " (" + CollectorController.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL proxyUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "htmlbody").replace(TransportFormat.XML.getCode(), "htmlbody") + '&' + "part" + '=' + partParameter);
            new LabradorRetriever(proxyUrl).copyTo(req, resp);
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String application, MonitoringController monitoringController) throws IOException {
        Serializable serializable;
        try {
            serializable = this.createSerializable(httpRequest, application);
        }
        catch (Exception e) {
            serializable = e;
        }
        monitoringController.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, String application) throws Exception {
        Serializable resultForSystemActions = this.createSerializableForSystemActions(httpRequest, application);
        if (resultForSystemActions != null) {
            return resultForSystemActions;
        }
        Collector collector = this.getCollectorByApplication(application);
        SerializableController serializableController = new SerializableController(collector);
        Range range = serializableController.getRangeForSerializable(httpRequest);
        String part = httpRequest.getParameter("part");
        if ("threads".equalsIgnoreCase(part)) {
            return new ArrayList<List<ThreadInformations>>(this.collectorServer.getThreadInformationsLists(application));
        }
        if ("currentRequests".equalsIgnoreCase(part)) {
            return new LinkedHashMap<JavaInformations, List<CounterRequestContext>>(this.collectorServer.collectCurrentRequests(application));
        }
        if ("explainPlan".equalsIgnoreCase(part)) {
            String sqlRequest = httpRequest.getHeader("request");
            return this.collectorServer.collectSqlRequestExplainPlan(application, sqlRequest);
        }
        if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String counterName = httpRequest.getParameter("counter");
            String requestId = httpRequest.getParameter("graph");
            Counter counter = collector.getRangeCounter(range, counterName);
            List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
            return new ArrayList<CounterRequest>(requestList);
        }
        if ("applications".equalsIgnoreCase(part)) {
            HashMap<String, Throwable> applications = new HashMap<String, Throwable>();
            for (String app : Parameters.getCollectorUrlsByApplications().keySet()) {
                applications.put(app, null);
            }
            applications.putAll(this.collectorServer.getLastCollectExceptionsByApplication());
            return new HashMap(applications);
        }
        if ("jrobins".equalsIgnoreCase(part) || "otherJRobins".equalsIgnoreCase(part)) {
            return serializableController.createSerializable(httpRequest, null, null);
        }
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return serializableController.createDefaultSerializable(javaInformationsList, range, null);
    }

    private Serializable createSerializableForSystemActions(HttpServletRequest httpRequest, String application) throws IOException {
        String part = httpRequest.getParameter("part");
        if ("jvm".equalsIgnoreCase(part)) {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            return new ArrayList<JavaInformations>(javaInformationsList);
        }
        if ("heaphisto".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return this.collectorServer.collectHeapHistogram(application);
        }
        if ("sessions".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String sessionId = httpRequest.getParameter("sessionId");
            List<SessionInformations> sessionInformations = this.collectorServer.collectSessionInformations(application, sessionId);
            if (sessionId != null && !sessionInformations.isEmpty()) {
                return sessionInformations.get(0);
            }
            return new ArrayList<SessionInformations>(sessionInformations);
        }
        if ("hotspots".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<SamplingProfiler.SampledMethod>(this.collectorServer.collectHotspots(application));
        }
        if ("processes".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new LinkedHashMap<String, List<ProcessInformations>>(this.collectorServer.collectProcessInformations(application));
        }
        if ("jndi".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String path = httpRequest.getParameter("path");
            return new ArrayList<JndiBinding>(this.collectorServer.collectJndiBindings(application, path));
        }
        if ("mbeans".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new LinkedHashMap<String, List<MBeanNode>>(this.collectorServer.collectMBeans(application));
        }
        if ("database".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            int requestIndex = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            return this.collectorServer.collectDatabaseInformations(application, requestIndex);
        }
        if ("connections".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<List<ConnectionInformations>>(this.collectorServer.collectConnectionInformations(application));
        }
        return null;
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, HttpServletResponse resp, PrintWriter writer, String application) {
        Range range = this.httpCookieManager.getRange(req, resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return new HtmlReport(collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
    }

    private static String getHostAndPort(URL url) {
        return RemoteCollector.getHostAndPort(url);
    }

    void writeMessage(HttpServletRequest req, HttpServletResponse resp, String application, String message) throws IOException {
        CollectorController.noCache(resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        if (application == null || collector == null || javaInformationsList == null) {
            CollectorController.showAlertAndRedirectTo(resp, message, "?");
        } else {
            PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
            String partParameter = req.getParameter("part");
            new HtmlReport(collector, this.collectorServer, javaInformationsList, Period.TOUT, (Writer)writer).writeMessageIfNotNull(message, partParameter);
            writer.close();
        }
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        CollectorController.noCache(httpResponse);
        httpResponse.setContentType("text/html; charset=UTF-8");
        return new PrintWriter(MonitoringController.getWriter(httpResponse));
    }

    static void writeOnlyAddApplication(HttpServletResponse resp) throws IOException {
        CollectorController.noCache(resp);
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        writer.write("<html lang='" + I18N.getCurrentLocale().getLanguage() + "'><head><title>Monitoring</title></head><body>");
        HtmlReport.writeAddAndRemoveApplicationLinks(null, writer);
        writer.write("</body></html>");
        writer.close();
    }

    static void showAlertAndRedirectTo(HttpServletResponse resp, String message, String redirectTo) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        writer.write("<script type='text/javascript'>alert('");
        writer.write(I18N.javascriptEncode(message));
        writer.write("');location.href='");
        writer.write(redirectTo);
        writer.write("';</script>");
        writer.close();
    }

    private static void noCache(HttpServletResponse httpResponse) {
        MonitoringController.noCache(httpResponse);
    }

    private String forwardActionAndUpdateData(HttpServletRequest req, String application) throws IOException {
        String actionParameter = req.getParameter("action");
        String sessionIdParameter = req.getParameter("sessionId");
        String threadIdParameter = req.getParameter("threadId");
        String jobIdParameter = req.getParameter("jobId");
        String cacheIdParameter = req.getParameter("cacheId");
        List<URL> urls = CollectorController.getUrlsByApplication(application);
        ArrayList<URL> actionUrls = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            StringBuilder actionUrl = new StringBuilder(url.toString());
            actionUrl.append("&action=").append(actionParameter);
            if (sessionIdParameter != null) {
                actionUrl.append("&sessionId=").append(sessionIdParameter);
            }
            if (threadIdParameter != null) {
                actionUrl.append("&threadId=").append(threadIdParameter);
            }
            if (jobIdParameter != null) {
                actionUrl.append("&jobId=").append(jobIdParameter);
            }
            if (cacheIdParameter != null) {
                actionUrl.append("&cacheId=").append(cacheIdParameter);
            }
            actionUrls.add(new URL(actionUrl.toString()));
        }
        return this.collectorServer.collectForApplicationForAction(application, actionUrls);
    }

    String getApplication(HttpServletRequest req, HttpServletResponse resp) {
        String application = req.getParameter("application");
        if (application == null) {
            Cookie cookie = this.httpCookieManager.getCookieByName(req, COOKIE_NAME);
            if (cookie != null && !this.collectorServer.isApplicationDataAvailable(application = cookie.getValue())) {
                cookie.setMaxAge(-1);
                resp.addCookie(cookie);
                application = null;
            }
            if (application == null) {
                application = this.collectorServer.getFirstApplication();
            }
        } else if (this.collectorServer.isApplicationDataAvailable(application)) {
            this.httpCookieManager.addCookie(req, resp, COOKIE_NAME, String.valueOf(application));
        }
        return application;
    }

    private Collector getCollectorByApplication(String application) {
        return this.collectorServer.getCollectorByApplication(application);
    }

    private List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.collectorServer.getJavaInformationsByApplication(application);
    }

    private static List<URL> getUrlsByApplication(String application) throws IOException {
        return CollectorServer.getUrlsByApplication(application);
    }
}

