/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

class ConnectionInformations
implements Serializable {
    private static final long serialVersionUID = -6063966419161604125L;
    private static final String OWN_PACKAGE = ConnectionInformations.class.getName().substring(0, ConnectionInformations.class.getName().lastIndexOf(46));
    private static final boolean CONNECTIONS_STACK_TRACES_DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.CONNECTIONS_STACK_TRACES_DISABLED));
    private final long openingTime = System.currentTimeMillis();
    private final StackTraceElement[] openingStackTrace;
    private final long threadId;

    ConnectionInformations() {
        Thread currentThread = Thread.currentThread();
        this.openingStackTrace = CONNECTIONS_STACK_TRACES_DISABLED ? null : currentThread.getStackTrace();
        this.threadId = currentThread.getId();
    }

    static int getUniqueIdOfConnection(Connection connection) {
        return System.identityHashCode(connection);
    }

    Date getOpeningDate() {
        return new Date(this.openingTime);
    }

    List<StackTraceElement> getOpeningStackTrace() {
        if (this.openingStackTrace == null) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>(Arrays.asList(this.openingStackTrace));
        stackTrace.remove(0);
        while (((StackTraceElement)stackTrace.get(0)).getClassName().startsWith(OWN_PACKAGE)) {
            stackTrace.remove(0);
        }
        return stackTrace;
    }

    long getThreadId() {
        return this.threadId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[openingDate=" + this.getOpeningDate() + ", threadId=" + this.getThreadId() + ']';
    }
}

