/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.PdfOtherReport;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SamplingProfiler;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.VirtualMachine;

class PdfController {
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;

    PdfController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        block8: {
            this.addPdfContentTypeAndDisposition(httpRequest, httpResponse);
            try {
                String part = httpRequest.getParameter("part");
                if (part == null) {
                    if (!this.isFromCollectorServer() && !this.collector.isStopped()) {
                        this.collector.collectLocalContextWithoutErrors();
                    }
                    Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                    PdfReport pdfReport = new PdfReport(this.collector, this.isFromCollectorServer(), javaInformationsList, range, (OutputStream)httpResponse.getOutputStream());
                    pdfReport.toPdf();
                    break block8;
                }
                try {
                    this.doPdfPart(httpRequest, httpResponse, part, javaInformationsList);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            finally {
                httpResponse.getOutputStream().flush();
            }
        }
    }

    private void doPdfPart(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String part, List<JavaInformations> javaInformationsList) throws Exception {
        boolean done = this.doPdfPartForSystemActions(httpRequest, httpResponse, part);
        if (done) {
            return;
        }
        if ("currentRequests".equalsIgnoreCase(part)) {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            this.doCurrentRequests(httpResponse, javaInformationsList, range);
        } else if ("runtimeDependencies".equalsIgnoreCase(part)) {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            String counterName = httpRequest.getParameter("counter");
            Counter counter = this.collector.getRangeCounter(range, counterName);
            PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
            pdfOtherReport.writeRuntimeDependencies(counter, range);
        } else if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String requestId = httpRequest.getParameter("graph");
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            String counterName = httpRequest.getParameter("counter");
            Counter counter = this.collector.getRangeCounter(range, counterName);
            PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
            pdfOtherReport.writeCounterSummaryPerClass(this.collector, counter, requestId, range);
        } else if ("graph".equalsIgnoreCase(part)) {
            String requestId = httpRequest.getParameter("graph");
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
            pdfOtherReport.writeRequestAndGraphDetail(this.collector, this.collectorServer, range, requestId);
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private boolean doPdfPartForSystemActions(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String part) throws Exception {
        if ("sessions".equalsIgnoreCase(part)) {
            this.doSessions(httpResponse);
        } else if ("hotspots".equalsIgnoreCase(part)) {
            this.doHotspots(httpResponse);
        } else if ("processes".equalsIgnoreCase(part)) {
            this.doProcesses(httpResponse);
        } else if ("database".equalsIgnoreCase(part)) {
            int index = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            this.doDatabase(httpResponse, index);
        } else if ("jndi".equalsIgnoreCase(part)) {
            this.doJndi(httpResponse, httpRequest.getParameter("path"));
        } else if ("mbeans".equalsIgnoreCase(part)) {
            this.doMBeans(httpResponse);
        } else if ("heaphisto".equalsIgnoreCase(part)) {
            this.doHeapHisto(httpResponse);
        } else {
            return false;
        }
        return true;
    }

    private void doCurrentRequests(HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, Range range) throws IOException {
        Map<JavaInformations, List<CounterRequestContext>> currentRequests;
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(range);
        if (!this.isFromCollectorServer()) {
            assert (this.collectorServer == null);
            assert (javaInformationsList.size() == 1);
            JavaInformations javaInformations = javaInformationsList.get(0);
            List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts(counters);
            currentRequests = Collections.singletonMap(javaInformations, rootCurrentContexts);
        } else {
            currentRequests = this.collectorServer.collectCurrentRequests(this.collector.getApplication());
        }
        long timeOfSnapshot = System.currentTimeMillis();
        pdfOtherReport.writeAllCurrentRequestsAsPart(currentRequests, this.collector, counters, timeOfSnapshot);
    }

    private void doSessions(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? SessionListener.getAllSessionsInformations() : this.collectorServer.collectSessionInformations(this.getApplication(), null);
        pdfOtherReport.writeSessionInformations(sessionsInformations);
    }

    private void doHotspots(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        if (!this.isFromCollectorServer()) {
            List<SamplingProfiler.SampledMethod> hotspots = this.collector.getHotspots();
            pdfOtherReport.writeHotspots(hotspots);
        } else {
            List<SamplingProfiler.SampledMethod> hotspots = this.collectorServer.collectHotspots(this.getApplication());
            pdfOtherReport.writeHotspots(hotspots);
        }
    }

    private void doProcesses(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        if (!this.isFromCollectorServer()) {
            List<ProcessInformations> processInformations = ProcessInformations.buildProcessInformations();
            pdfOtherReport.writeProcessInformations(processInformations);
        } else {
            Map<String, List<ProcessInformations>> processesByTitle = this.collectorServer.collectProcessInformations(this.getApplication());
            pdfOtherReport.writeProcessInformations(processesByTitle);
        }
    }

    private void doDatabase(HttpServletResponse httpResponse, int index) throws Exception {
        Action.checkSystemActionsEnabled();
        DatabaseInformations databaseInformations = !this.isFromCollectorServer() ? new DatabaseInformations(index) : this.collectorServer.collectDatabaseInformations(this.getApplication(), index);
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        pdfOtherReport.writeDatabaseInformations(databaseInformations);
    }

    private void doJndi(HttpServletResponse httpResponse, String path) throws Exception {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        List<JndiBinding> jndiBindings = !this.isFromCollectorServer() ? JndiBinding.listBindings(path) : this.collectorServer.collectJndiBindings(this.getApplication(), path);
        pdfOtherReport.writeJndi(jndiBindings, JndiBinding.normalizePath(path));
    }

    private void doMBeans(HttpServletResponse httpResponse) throws Exception {
        Action.checkSystemActionsEnabled();
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        if (!this.isFromCollectorServer()) {
            List<MBeanNode> nodes = MBeans.getAllMBeanNodes();
            pdfOtherReport.writeMBeans(nodes);
        } else {
            Map<String, List<MBeanNode>> allMBeans = this.collectorServer.collectMBeans(this.getApplication());
            pdfOtherReport.writeMBeans(allMBeans);
        }
    }

    private void doHeapHisto(HttpServletResponse httpResponse) throws Exception {
        Action.checkSystemActionsEnabled();
        HeapHistogram heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.getApplication());
        PdfOtherReport pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
        pdfOtherReport.writeHeapHistogram(heapHistogram);
    }

    void addPdfContentTypeAndDisposition(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        httpResponse.setContentType("application/pdf");
        String contentDisposition = PdfController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.getApplication()));
        httpResponse.addHeader("Content-Disposition", contentDisposition.replace('\n', '_').replace('\r', '_'));
    }

    private String getApplication() {
        return this.collector.getApplication();
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return PdfController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (PdfController.isEncodingNotNeeded(c)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isEncodingNotNeeded(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_';
    }
}

