/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.Plugin;
import hudson.util.PluginServletFilter;
import java.io.File;
import java.util.Arrays;
import java.util.logging.LogRecord;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import org.jvnet.hudson.plugins.monitoring.HudsonMonitoringFilter;

public class PluginImpl
extends Plugin {
    private ServletContext context;
    private HudsonMonitoringFilter filter;

    public void start() throws Exception {
        super.start();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            this.context = jenkins.servletContext;
        }
        if (this.isParameterUndefined("javamelody.system-actions-enabled")) {
            System.setProperty("javamelody.system-actions-enabled", "true");
        }
        if (this.isParameterUndefined("javamelody.no-database")) {
            System.setProperty("javamelody.no-database", "true");
        }
        if (this.isParameterUndefined("javamelody.storage-directory")) {
            System.setProperty("javamelody.storage-directory", "/" + new File(jenkins.getRootDir(), "monitoring").getAbsolutePath());
        }
        if (this.isParameterUndefined("javamelody.analytics-disabled") && this.isParameterUndefined("javamelody.analytics-id")) {
            System.setProperty("javamelody.analytics-id", "UA-1335263-7");
        }
        if (this.isParameterUndefined("javamelody.http-transform-pattern")) {
            System.setProperty("javamelody.http-transform-pattern", "/\\d+/|/site/.+|avadoc/.+|/ws/.+|obertura/.+|estReport/.+|iolations/file/.+|/user/.+|/static/\\w+/|/adjuncts/\\w+/|/bound/[\\w\\-]+");
        }
        if (this.isParameterUndefined("javamelody.custom-reports")) {
            System.setProperty("javamelody.custom-reports", "Jenkins Info,About Monitoring");
            System.setProperty("javamelody.Jenkins Info", "/systemInfo");
            System.setProperty("javamelody.About Monitoring", "https://wiki.jenkins-ci.org/display/JENKINS/Monitoring");
        }
        if (this.isParameterUndefined("javamelody.gzip-compression-disabled")) {
            System.setProperty("javamelody.gzip-compression-disabled", "true");
        }
        Arrays.hashCode(new Class[]{LogRecord.class});
        this.filter = new HudsonMonitoringFilter();
        PluginServletFilter.addFilter((Filter)this.filter);
    }

    private boolean isParameterUndefined(String key) {
        return System.getProperty(key) == null && this.context != null && this.context.getInitParameter(key) == null;
    }

    HudsonMonitoringFilter getFilter() {
        return this.filter;
    }

    public void postInitialize() throws Exception {
        super.postInitialize();
        if (this.filter == null) {
            throw new Exception("Post-initialization hook has been called before the plugin start. Filters are not available");
        }
        this.filter.getNodesCollector().init();
    }

    public void stop() throws Exception {
        if (this.filter != null && this.filter.getNodesCollector() != null) {
            this.filter.getNodesCollector().stop();
        }
        super.stop();
    }
}

