/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.BuildStepListener;
import hudson.tasks.BuildStep;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRunListener;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

@Extension
public class CounterBuildStepListener
extends BuildStepListener {
    private static final Counter BUILD_COUNTER = CounterRunListener.getBuildCounter();
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter((Parameter)Parameter.DISABLED));

    public void started(AbstractBuild build, BuildStep buildStep, BuildListener listener) {
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        String jobName = build.getProject().getName();
        String buildStepName = buildStep.getClass().getSimpleName();
        String name = jobName + " / " + buildStepName;
        BUILD_COUNTER.bindContextIncludingCpu(name);
    }

    public void finished(AbstractBuild build, BuildStep buildStep, BuildListener listener, boolean canContinue) {
        if (DISABLED || !BUILD_COUNTER.isDisplayed()) {
            return;
        }
        boolean error = false;
        BUILD_COUNTER.addRequestForCurrentContext(false);
    }
}

