/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.constants.MoSecurityQuestionsConstant;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.MoUserAuth;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MoSecurityQuestionConfig
extends UserProperty
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MoSecurityQuestionConfig.class.getName());
    private Secret firstSecurityQuestion;
    private Secret secondSecurityQuestion;
    private Secret customSecurityQuestion;
    private Secret firstSecurityQuestionAnswer;
    private Secret secondSecurityQuestionAnswer;
    private Secret customSecurityQuestionAnswer;
    private boolean isConfigured;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public MoSecurityQuestionConfig(Secret firstSecurityQuestion, Secret secondSecurityQuestion, Secret customSecurityQuestion, Secret firstSecurityQuestionAnswer, Secret secondSecurityQuestionAnswer, Secret customSecurityQuestionAnswer, boolean isConfigured) {
        this.firstSecurityQuestion = firstSecurityQuestion;
        this.secondSecurityQuestion = secondSecurityQuestion;
        this.customSecurityQuestion = customSecurityQuestion;
        this.firstSecurityQuestionAnswer = firstSecurityQuestionAnswer;
        this.secondSecurityQuestionAnswer = secondSecurityQuestionAnswer;
        this.customSecurityQuestionAnswer = customSecurityQuestionAnswer;
        this.isConfigured = isConfigured;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Security question";
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_SECURITY_QUESTION_CONFIG.getUrl();
    }

    public boolean isUserAuthenticatedFromTfa() {
        return MoFilter.userAuthenticationStatus.getOrDefault(this.user.getId(), false);
    }

    public String getBaseUrl() {
        return Jenkins.get().getRootUrl();
    }

    private boolean isFormFilledCorrectly(JSONObject json) {
        return !json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_FIRST_SECURITY_QUESTION.getKey()).equals(json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_SECOND_SECURITY_QUESTION.getKey())) && !json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_FIRST_SECURITY_QUESTION.getKey()).equals(MoSecurityQuestionsConstant.SecurityQuestions.SELECT_SECURITY_QUESTION.getQuestion()) && !json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_SECOND_SECURITY_QUESTION.getKey()).equals(MoSecurityQuestionsConstant.SecurityQuestions.SELECT_SECURITY_QUESTION.getQuestion()) && StringUtils.isNotBlank((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_CUSTOM_SECURITY_QUESTION.getKey())) && StringUtils.isNotBlank((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_FIRST_SECURITY_QUESTION_ANSWER.getKey())) && StringUtils.isNotBlank((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_SECOND_SECURITY_QUESTION_ANSWER.getKey())) && StringUtils.isNotBlank((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_CUSTOM_SECURITY_QUESTION_ANSWER.getKey()));
    }

    @RequirePOST
    public void doSaveSecurityQuestion(StaplerRequest req, StaplerResponse rsp) throws Exception {
        Jenkins.get().checkPermission(Jenkins.READ);
        LOGGER.fine("Saving user security questions");
        JSONObject json = req.getSubmittedForm();
        Object redirectUrl = req.getContextPath() + "./";
        boolean firstTimeUserLogIn = false;
        User user = User.current();
        try {
            if (this.isFormFilledCorrectly(json)) {
                if (user != null) {
                    MoSecurityQuestionConfig userSecurityQuestion = (MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class);
                    userSecurityQuestion.setFirstSecurityQuestion(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_FIRST_SECURITY_QUESTION.getKey())));
                    userSecurityQuestion.setSecondSecurityQuestion(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_SECOND_SECURITY_QUESTION.getKey())));
                    userSecurityQuestion.setCustomSecurityQuestion(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_CUSTOM_SECURITY_QUESTION.getKey())));
                    userSecurityQuestion.setFirstSecurityQuestionAnswer(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_FIRST_SECURITY_QUESTION_ANSWER.getKey())));
                    userSecurityQuestion.setSecondSecurityQuestionAnswer(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_SECOND_SECURITY_QUESTION_ANSWER.getKey())));
                    userSecurityQuestion.setCustomSecurityQuestionAnswer(Secret.fromString((String)json.getString(MoSecurityQuestionsConstant.UserSecurityQuestionKey.USER_CUSTOM_SECURITY_QUESTION_ANSWER.getKey())));
                    userSecurityQuestion.setConfigured(true);
                    user.save();
                }
                HttpSession session = req.getSession(false);
                assert (user != null);
                if (session != null) {
                    redirectUrl = (String)session.getAttribute("tfaRelayState");
                    session.removeAttribute("tfaRelayState");
                    session.setAttribute(user.getId() + MoGlobalConfigConstant.UtilityGlobalConstants.SESSION_2FA_VERIFICATION.getKey(), (Object)"true");
                    MoFilter.userAuthenticationStatus.put(user.getId(), true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.fine("Error in saving security questions, Form is not filled correctly ");
            throw new Exception("Cannot save security questions, exception is " + e.getMessage());
        }
        if (redirectUrl == null) {
            redirectUrl = Jenkins.get().getRootUrl();
        }
        LOGGER.fine("Redirecting user to " + (String)redirectUrl);
        FormApply.success((String)redirectUrl).generateResponse(req, rsp, null);
    }

    @RequirePOST
    public void doReset(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.READ);
        try {
            MoSecurityQuestionConfig userSecurityQuestion = (MoSecurityQuestionConfig)this.user.getProperty(MoSecurityQuestionConfig.class);
            userSecurityQuestion.setFirstSecurityQuestion(Secret.fromString((String)""));
            userSecurityQuestion.setSecondSecurityQuestion(Secret.fromString((String)""));
            userSecurityQuestion.setCustomSecurityQuestion(Secret.fromString((String)""));
            userSecurityQuestion.setFirstSecurityQuestionAnswer(Secret.fromString((String)""));
            userSecurityQuestion.setSecondSecurityQuestionAnswer(Secret.fromString((String)""));
            userSecurityQuestion.setCustomSecurityQuestionAnswer(Secret.fromString((String)""));
            userSecurityQuestion.setConfigured(false);
            LOGGER.fine("Resetting the security question authentication method");
            this.user.save();
        }
        catch (Exception e) {
            LOGGER.fine("Error in resetting the configuration " + e.getMessage());
        }
        FormApply.success((String)req.getReferer()).generateResponse(req, rsp, null);
    }

    public String getFirstSecurityQuestion(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).firstSecurityQuestion.getPlainText();
    }

    public String getSecondSecurityQuestion(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).secondSecurityQuestion.getPlainText();
    }

    public String getCustomSecurityQuestion(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).customSecurityQuestion.getPlainText();
    }

    public String getFirstSecurityQuestionAnswer(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).firstSecurityQuestionAnswer.getPlainText();
    }

    public String getSecondSecurityQuestionAnswer(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).secondSecurityQuestionAnswer.getPlainText();
    }

    public String getCustomSecurityQuestionAnswer(User user) {
        return ((MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class)).customSecurityQuestionAnswer.getPlainText();
    }

    public void setFirstSecurityQuestion(Secret firstSecurityQuestion) {
        this.firstSecurityQuestion = firstSecurityQuestion;
    }

    public void setSecondSecurityQuestion(Secret secondSecurityQuestion) {
        this.secondSecurityQuestion = secondSecurityQuestion;
    }

    public void setCustomSecurityQuestion(Secret customSecurityQuestion) {
        this.customSecurityQuestion = customSecurityQuestion;
    }

    public void setFirstSecurityQuestionAnswer(Secret firstSecurityQuestionAnswer) {
        this.firstSecurityQuestionAnswer = firstSecurityQuestionAnswer;
    }

    public void setSecondSecurityQuestionAnswer(Secret secondSecurityQuestionAnswer) {
        this.secondSecurityQuestionAnswer = secondSecurityQuestionAnswer;
    }

    public void setCustomSecurityQuestionAnswer(Secret customSecurityQuestionAnswer) {
        this.customSecurityQuestionAnswer = customSecurityQuestionAnswer;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setConfigured(boolean Configured) {
        this.isConfigured = Configured;
    }

    public UserPropertyDescriptor getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public DescriptorImpl() {
            super(MoSecurityQuestionConfig.class);
        }

        public String getContextPath() {
            return MoUserAuth.getContextPath();
        }

        public UserProperty newInstance(User user) {
            return new MoSecurityQuestionConfig(Secret.fromString((String)""), Secret.fromString((String)""), Secret.fromString((String)""), Secret.fromString((String)""), Secret.fromString((String)""), Secret.fromString((String)""), false);
        }

        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="Intentionally returning null to hide from UI")
        public String getDisplayName() {
            return null;
        }

        public Boolean showInUserProfile() {
            return MoFilter.moPluginSettings.getOrDefault(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), false) != false && MoGlobalConfig.get().isEnableSecurityQuestionsAuthentication() != false;
        }

        public String getUserId() {
            User currentUser = User.current();
            if (currentUser == null) {
                return "";
            }
            return currentUser.getId();
        }

        private ListBoxModel fillSecurityQuestion() {
            ListBoxModel securityQuestionsDropDown = new ListBoxModel();
            for (MoSecurityQuestionsConstant.SecurityQuestions securityQuestion : MoSecurityQuestionsConstant.SecurityQuestions.values()) {
                securityQuestionsDropDown.add((Object)new ListBoxModel.Option(securityQuestion.getQuestion()));
            }
            return securityQuestionsDropDown;
        }

        @RequirePOST
        public ListBoxModel doFillFirstSecurityQuestionItems() {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.fillSecurityQuestion();
        }

        @RequirePOST
        public ListBoxModel doFillSecondSecurityQuestionItems() {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.fillSecurityQuestion();
        }

        private FormValidation validateForm(boolean condition, String errorMessage) {
            if (condition) {
                return FormValidation.error((String)errorMessage);
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckFirstSecurityQuestion(@QueryParameter String firstSecurityQuestion, @QueryParameter String secondSecurityQuestion) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(firstSecurityQuestion.equals(MoSecurityQuestionsConstant.SecurityQuestions.SELECT_SECURITY_QUESTION.getQuestion()) || firstSecurityQuestion.equals(secondSecurityQuestion), "Please select a valid security question");
        }

        @RequirePOST
        public FormValidation doCheckFirstSecurityQuestionAnswer(@QueryParameter String firstSecurityQuestionAnswer, @QueryParameter String secondSecurityQuestion) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(StringUtils.isBlank((String)firstSecurityQuestionAnswer), "Please Enter valid answer");
        }

        @RequirePOST
        public FormValidation doCheckSecondSecurityQuestion(@QueryParameter String secondSecurityQuestion, @QueryParameter String firstSecurityQuestion) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(secondSecurityQuestion.equals(MoSecurityQuestionsConstant.SecurityQuestions.SELECT_SECURITY_QUESTION.getQuestion()) || secondSecurityQuestion.equals(firstSecurityQuestion), "Please select a valid security question");
        }

        @RequirePOST
        public FormValidation doCheckSecondSecurityQuestionAnswer(@QueryParameter String secondSecurityQuestionAnswer) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(StringUtils.isBlank((String)secondSecurityQuestionAnswer), "Please Enter valid answer");
        }

        @RequirePOST
        public FormValidation doCheckCustomSecurityQuestion(@QueryParameter String customSecurityQuestion) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(StringUtils.isBlank((String)customSecurityQuestion), "Please select a valid security question");
        }

        @RequirePOST
        public FormValidation doCheckCustomSecurityQuestionAnswer(@QueryParameter String customSecurityQuestionAnswer) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return this.validateForm(StringUtils.isBlank((String)customSecurityQuestionAnswer), "Please Enter valid answer");
        }
    }
}

