/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import hudson.Extension;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Extension
public class MoSAMLCrumbExclusion
extends CrumbExclusion {
    private static final Logger LOGGER = Logger.getLogger(MoSAMLCrumbExclusion.class.getName());
    private static final String MO_JENKINS_LOGIN_ACTION = "/securityRealm/moLoginAction";
    private static final String MO_JENKINS_SAML_LOGIN_ACTION = "/securityRealm/moSamlLogin";
    private static final String MO_SAML_SSO_FORCE_STOP = "/securityRealm/moSAMLSingleSignOnForceStop";
    private static final String MO_SAML_SP_AUTH_URL = "/securityRealm/moSamlAuth";

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (this.ignoreCrumbCheck(pathInfo)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean ignoreCrumbCheck(String pathInfo) {
        if (pathInfo != null && (pathInfo.equals(MO_JENKINS_LOGIN_ACTION) || pathInfo.equals("/securityRealm/moLoginAction/") || pathInfo.equals(MO_JENKINS_SAML_LOGIN_ACTION))) {
            return true;
        }
        if (pathInfo != null && (pathInfo.equals(MO_SAML_SSO_FORCE_STOP) || pathInfo.equals("/securityRealm/moSAMLSingleSignOnForceStop/"))) {
            return true;
        }
        if (pathInfo != null && (pathInfo.equals(MO_SAML_SP_AUTH_URL) || pathInfo.equals("/securityRealm/moSamlAuth/"))) {
            return true;
        }
        LOGGER.fine("Invalid Request");
        return false;
    }
}

