/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.miniorange.saml.MoSAMLUtils;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MoIDPMetadata {
    private static Log LOGGER = LogFactory.getLog(MoIDPMetadata.class);
    private String metadata;
    private EntityDescriptor entityDescriptor;
    public String entityId;
    private Map<String, String> singleSignOnServices;
    private Map<String, String> singleLogoutServices;
    public List<String> signingCertificates;
    public static String certificate;
    public static String nameIdFormat;

    public MoIDPMetadata(String metadata) {
        block8: {
            String FEATURE = null;
            try {
                String location;
                String binding;
                if (!StringUtils.isNotBlank((CharSequence)metadata) || !metadata.trim().startsWith("<") || !metadata.trim().endsWith(">")) break block8;
                this.metadata = StringUtils.trimToEmpty((String)metadata);
                MoSAMLUtils.doBootstrap();
                DOMParser parser = new DOMParser();
                FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
                parser.setFeature(FEATURE, true);
                FEATURE = "http://xml.org/sax/features/external-general-entities";
                parser.setFeature(FEATURE, false);
                FEATURE = "http://xml.org/sax/features/external-parameter-entities";
                parser.setFeature(FEATURE, false);
                FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
                parser.setFeature(FEATURE, false);
                parser.parse(new InputSource(new StringReader(this.metadata)));
                Document document = parser.getDocument();
                Element element = document.getDocumentElement();
                UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
                Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
                XMLObject xmlObj = unmarshaller.unmarshall(element);
                this.entityDescriptor = (EntityDescriptor)xmlObj;
                IDPSSODescriptor idpssoDescriptor = this.entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                if (idpssoDescriptor == null) break block8;
                this.entityId = this.entityDescriptor.getEntityID();
                LOGGER.debug((Object)("EntityID: " + this.entityId));
                this.singleSignOnServices = new HashMap<String, String>();
                for (SingleSignOnService ssoService : idpssoDescriptor.getSingleSignOnServices()) {
                    binding = ssoService.getBinding();
                    location = ssoService.getLocation();
                    if (!StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                    LOGGER.debug((Object)("SingleSignOnService Binding: " + binding + ", Location: " + location));
                    this.singleSignOnServices.put(binding, location);
                }
                this.singleLogoutServices = new HashMap<String, String>();
                for (SingleLogoutService sloService : idpssoDescriptor.getSingleLogoutServices()) {
                    binding = sloService.getBinding();
                    location = sloService.getLocation();
                    if (!StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !StringUtils.equals((CharSequence)binding, (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                    LOGGER.debug((Object)("SingleLogoutService Binding: " + binding + ", Location: " + location));
                    this.singleLogoutServices.put(binding, location);
                }
                nameIdFormat = !idpssoDescriptor.getNameIDFormats().isEmpty() ? (String)StringUtils.defaultIfBlank((CharSequence)((NameIDFormat)idpssoDescriptor.getNameIDFormats().get(0)).getFormat(), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified") : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
                this.signingCertificates = new ArrayList<String>();
                for (KeyDescriptor key : idpssoDescriptor.getKeyDescriptors()) {
                    certificate = null;
                    if (key.getKeyInfo().getX509Datas().size() > 0 && ((X509Data)key.getKeyInfo().getX509Datas().get(0)).getX509Certificates().size() > 0) {
                        certificate = ((X509Certificate)((X509Data)key.getKeyInfo().getX509Datas().get(0)).getX509Certificates().get(0)).getValue();
                    }
                    if (!StringUtils.isBlank((CharSequence)certificate)) {
                        if (UsageType.UNSPECIFIED.equals((Object)key.getUse()) && MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue()) {
                            this.signingCertificates.add(certificate);
                        }
                        if (!UsageType.SIGNING.equals((Object)key.getUse()) || !MoSAMLUtils.isValidPublicCertificate(certificate).booleanValue()) continue;
                        this.signingCertificates.add(certificate);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                LOGGER.debug((Object)("Exception occurs while parsing metadata xml " + t));
            }
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Map<String, String> getSingleSignOnServices() {
        return this.singleSignOnServices;
    }

    public Map<String, String> getSingleLogoutServices() {
        return this.singleLogoutServices;
    }

    public List<String> getSigningCertificates() {
        return this.signingCertificates;
    }
}

