/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;
import org.miniorange.saml.MoSAMLException;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MoSAMLUtils {
    private static boolean bootstrap = false;
    public static final String SAML_REQUEST_PARAM = "SAMLRequest";
    public static final String RELAY_STATE_PARAM = "RelayState";
    public static final String SIGNATURE_ALGO_PARAM = "SigAlg";
    public static final String SIGNATURE_PARAM = "Signature";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    private static final Logger LOGGER = Logger.getLogger(MoSAMLUtils.class.getName());

    public static void doBootstrap() {
        if (!bootstrap) {
            try {
                bootstrap = true;
                DefaultBootstrap.bootstrap();
            }
            catch (ConfigurationException e) {
                LOGGER.fine("Failed to bootstrap, error is " + e.getMessage());
            }
        }
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        text = Jsoup.parse((String)text).text();
        return text;
    }

    public static Response decodeResponse(String encodedResponse) throws Exception {
        LOGGER.fine("Decoding Response..");
        String xml = new String(org.opensaml.xml.util.Base64.decode((String)encodedResponse), "UTF-8");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        MoSAMLUtils.disableExternalEntityParsing(documentBuilderFactory);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject xmlObj = unmarshaller.unmarshall(element);
        Response response = (Response)xmlObj;
        return response;
    }

    public static AuthnRequest buildAuthnRequest(String issuer, String acsUrl, String destination, String nameIdFormat, Boolean forceAuthn, String authnContextClass) {
        LOGGER.fine("Building Authentication Request");
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        DateTime issueInstant = new DateTime();
        authnRequest.setID(MoSAMLUtils.generateRandomString());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(issueInstant);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setIssuer(MoSAMLUtils.buildIssuer(issuer));
        authnRequest.setAssertionConsumerServiceURL(acsUrl);
        authnRequest.setDestination(destination);
        if (forceAuthn.booleanValue()) {
            authnRequest.setForceAuthn(forceAuthn);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authnContextClass) && !authnContextClass.equals("None")) {
            authnRequest.setRequestedAuthnContext(MoSAMLUtils.buildRequestedAuthnContext(authnContextClass));
        }
        NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
        nameIdPolicy.setFormat(nameIdFormat);
        nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nameIdPolicy);
        return authnRequest;
    }

    private static Issuer buildIssuer(String issuerValue) {
        LOGGER.fine("Building Issuer");
        Issuer issuer = new IssuerBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml");
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static RequestedAuthnContext buildRequestedAuthnContext(String authnContextClassRefValue) {
        AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
        AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml");
        authnContextClassRef.setAuthnContextClassRef(authnContextClassRefValue);
        RequestedAuthnContextBuilder requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
        RequestedAuthnContext requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        return requestedAuthnContext;
    }

    public static Assertion decryptAssertion(EncryptedAssertion encryptedAssertion, String publicKey, String privateKey) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, DecryptionException {
        LOGGER.fine("Decrypting Assertion.");
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(MoSAMLUtils.getCredential(publicKey, privateKey));
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
        Iterator it = decrypter.getEncryptedKeyResolver().resolve(encryptedAssertion.getEncryptedData()).iterator();
        if (!it.hasNext()) {
            decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new EncryptedElementTypeEncryptedKeyResolver());
        }
        decrypter.setRootInNewDocument(true);
        return decrypter.decrypt(encryptedAssertion);
    }

    public static Boolean verifyCertificate(SignableXMLObject response, String certificate) throws ValidationException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        LOGGER.fine("verifying Certificate");
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(response.getSignature());
            Credential verificationCredential = MoSAMLUtils.getCredential(certificate, "");
            SignatureValidator sigValidator = new SignatureValidator(verificationCredential);
            LOGGER.fine("Validating signature.");
            sigValidator.validate(response.getSignature());
            LOGGER.fine("Signature validated.");
            return Boolean.TRUE;
        }
        if (response instanceof Response) {
            LOGGER.fine("Response not Signed");
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.RESPONSE_NOT_SIGNED);
        }
        LOGGER.fine("Assertion not Signed");
        throw new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
    }

    public static String generateRandomString() {
        String uuid = UUID.randomUUID().toString();
        return "_" + org.apache.commons.lang3.StringUtils.remove((String)uuid, (char)'-');
    }

    private static Credential getCredential(String publicKey, String privateKeyStr) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        publicKey = MoSAMLUtils.serializePublicCertificate(publicKey);
        ByteArrayInputStream is = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        BasicX509Credential x509Credential = new BasicX509Credential();
        x509Credential.setPublicKey(cert.getPublicKey());
        PrivateKey privateKey = MoSAMLUtils.getPrivateKey(privateKeyStr);
        if (privateKey != null) {
            x509Credential.setPrivateKey(privateKey);
        }
        BasicX509Credential credential = x509Credential;
        return credential;
    }

    public static String serializePublicCertificate(String certificate) {
        LOGGER.fine("Serializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\r");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\n");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"-");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            StringBuffer cert = new StringBuffer("-----" + BEGIN_CERTIFICATE + "-----\r\n");
            cert.append(certificate);
            cert.append("-----" + END_CERTIFICATE + "-----");
            return cert.toString();
        }
        return certificate;
    }

    public static String deserializePublicCertificate(String certificate) {
        LOGGER.fine("Deserializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\r");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\n");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"-");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static String serializePrivateCertificate(String certificate) {
        LOGGER.fine("Serializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\r");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\n");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"-");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            StringBuffer cert = new StringBuffer("-----" + BEGIN_CERTIFICATE + "-----\r\n");
            cert.append(certificate);
            cert.append("-----" + END_CERTIFICATE + "-----");
            return cert.toString();
        }
        return certificate;
    }

    public static String deserializePrivateCertificate(String certificate) {
        LOGGER.fine("Deserializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\r");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"\n");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)"-");
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = org.apache.commons.lang3.StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static String base64EncodeRequest(XMLObject request, Boolean isHttpPostBinding) throws Exception {
        LOGGER.fine("Encoding Sign Request with Base64 encoder.");
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(request);
        Element authDOM = marshaller.marshall(request);
        StringWriter requestWriter = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, (Writer)requestWriter);
        String requestMessage = requestWriter.toString();
        if (isHttpPostBinding.booleanValue()) {
            String authnRequestStr = org.opensaml.xml.util.Base64.encodeBytes((byte[])requestMessage.getBytes(StandardCharsets.UTF_8), (int)8);
            return authnRequestStr;
        }
        Deflater deflater = new Deflater(-1, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(requestMessage.getBytes(StandardCharsets.UTF_8));
        deflaterOutputStream.close();
        byteArrayOutputStream.close();
        String encodedRequestMessage = org.opensaml.xml.util.Base64.encodeBytes((byte[])byteArrayOutputStream.toByteArray(), (int)8);
        return encodedRequestMessage;
    }

    public static String signHttpRedirectRequest(String requestQueryString, String sigAlgo, String pubicKey, String privateKey) throws Exception {
        LOGGER.fine("Signing Http Redirect Request called ");
        StringBuilder builder = new StringBuilder(requestQueryString);
        builder.append("&").append(SIGNATURE_ALGO_PARAM).append("=").append(URLEncoder.encode(sigAlgo, "UTF-8"));
        java.security.Signature signature = java.security.Signature.getInstance("SHA256withRSA");
        Credential credentials = MoSAMLUtils.getCredential(pubicKey, privateKey);
        signature.initSign(credentials.getPrivateKey());
        signature.update(builder.toString().getBytes(StandardCharsets.UTF_8));
        byte[] signatureByteArray = signature.sign();
        String signatureBase64encodedString = org.opensaml.xml.util.Base64.encodeBytes((byte[])signatureByteArray);
        return signatureBase64encodedString;
    }

    private static void disableExternalEntityParsing(DocumentBuilderFactory dbf) {
        LOGGER.info("Disabling External Entity Parsing from DocumentBuilderFactory");
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(FEATURE, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            LOGGER.fine("ParserConfigurationException was thrown. The feature '" + FEATURE + "' is probably not supported by your XML processor.");
        }
    }

    private static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        LOGGER.fine("getPrivateKey called ");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)privateKey)) {
            privateKey = MoSAMLUtils.deserializePrivateCertificate(privateKey);
            byte[] bytes = org.opensaml.xml.util.Base64.decode((String)privateKey);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        return null;
    }

    public static Boolean isValidPublicCertificate(String certificate) {
        LOGGER.fine("Validating Public Certificate");
        certificate = MoSAMLUtils.serializePublicCertificate(certificate);
        Boolean isCertificateValid = Boolean.FALSE;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8)));
            if (cert != null) {
                isCertificateValid = Boolean.TRUE;
            }
        }
        catch (CertificateException e) {
            LOGGER.fine(e.getMessage());
        }
        return isCertificateValid;
    }

    public static SignableSAMLObject signHttpPostRequest(SignableSAMLObject request, String pubicKey, String privateKey) throws Exception {
        LOGGER.fine("Signing HTTP Post Request. ");
        Signature signature = (Signature)Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        Credential credential = MoSAMLUtils.getCredential(pubicKey, privateKey);
        signature.setSigningCredential(credential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        KeyInfoGeneratorManager keyInfoGeneratorManager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager().getDefaultManager();
        KeyInfoGeneratorFactory keyInfoGeneratorFactory = keyInfoGeneratorManager.getFactory(credential);
        KeyInfo keyInfo = keyInfoGeneratorFactory.newInstance().generate(credential);
        signature.setKeyInfo(keyInfo);
        String signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        signature.setSignatureAlgorithm(signatureAlgo);
        request.setSignature(signature);
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)request);
        marshaller.marshall((XMLObject)request);
        Signer.signObject((Signature)signature);
        return request;
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        return RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
    }
}

