/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.RootAction;
import hudson.security.SecurityRealm;
import hudson.util.FormApply;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.miniorange.saml.MoSAMLAddIdp;

public class MoGroupConfiguration
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(MoGroupConfiguration.class.getName());

    public String getIconFileName() {
        return "symbol-people";
    }

    public String getDisplayName() {
        return "GroupConfiguration";
    }

    public String getUrlName() {
        return "GroupConfiguration";
    }

    @CheckForNull
    public SecurityRealm getRealm() {
        SecurityRealm realm = Jenkins.get().getSecurityRealm();
        if (realm instanceof MoSAMLAddIdp) {
            return realm;
        }
        return null;
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doSaveConfiguration(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        try {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JSONObject json = request.getSubmittedForm();
            MoSAMLAddIdp currentConfiguration = (MoSAMLAddIdp)Jenkins.get().getSecurityRealm();
            currentConfiguration.setCrowdURL(json.getString("crowdURL"));
            currentConfiguration.setCrowdApplicationName(json.getString("crowdApplicationName"));
            currentConfiguration.setCrowdApplicationPassword(Secret.fromString((String)json.getString("crowdApplicationPassword")));
            LOGGER.log(Level.FINE, "Setting Group Configurations: {0}", json.toString());
            Jenkins.get().save();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error while submitting global configurations, error: {0}", e.getMessage());
        }
        FormApply.success((String)"./").generateResponse(request, response, null);
    }
}

