/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.MetricRegistry;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.MetricProvider;
import net.jcip.annotations.GuardedBy;

class MetricProviderListener
extends ExtensionListListener {
    private static final Logger LOGGER = Logger.getLogger(MetricProviderListener.class.getName());
    @GuardedBy(value="self")
    private final IdentityHashMap<MetricProvider, Void> registered = new IdentityHashMap();
    private final ExtensionList<MetricProvider> extensionList;
    private final MetricRegistry registry;

    private MetricProviderListener(ExtensionList<MetricProvider> extensionList, MetricRegistry registry) {
        this.extensionList = extensionList;
        this.registry = registry;
    }

    public static void attach(MetricRegistry registry) {
        MetricProviderListener listener = new MetricProviderListener((ExtensionList<MetricProvider>)ExtensionList.lookup(MetricProvider.class), registry);
        listener.onChange();
        listener.extensionList.addListener((ExtensionListListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange() {
        IdentityHashMap<MetricProvider, Void> identityHashMap = this.registered;
        synchronized (identityHashMap) {
            for (MetricProvider p : this.extensionList) {
                if (this.registered.containsKey(p)) continue;
                LOGGER.log(Level.FINER, "Registering metric provider {0} (type {1})", new Object[]{p, p.getClass()});
                this.registry.registerAll(p.getMetricSet());
                this.registered.put(p, null);
            }
        }
    }
}

