/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.util;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.PeriodicWork;
import hudson.util.VersionNumber;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class AutoSamplingHistogram
extends Histogram {
    private static final Logger LOGGER = Logger.getLogger(AutoSamplingHistogram.class.getName());
    private final Gauge<? extends Number> source;
    private volatile transient boolean badGauge;

    public AutoSamplingHistogram(Gauge<? extends Number> source) {
        this(source, (Reservoir)new ExponentiallyDecayingReservoir());
    }

    public AutoSamplingHistogram(Gauge<? extends Number> source, Reservoir reservoir) {
        super(reservoir);
        this.source = source;
    }

    public void update() {
        try {
            Number value = (Number)this.source.getValue();
            if (value instanceof Integer) {
                this.update(value.intValue());
            } else if (value != null) {
                this.update(value.longValue());
            } else {
                LOGGER.log(Level.FINE, "Gauge {0} returned null", this.source);
            }
            this.badGauge = false;
        }
        catch (ClassCastException e) {
            LogRecord lr = new LogRecord(this.badGauge ? Level.FINE : Level.WARNING, "Gauge {0} is supposed to return a subclass of java.lang.Number but didn't");
            this.badGauge = true;
            lr.setThrown(e);
            lr.setParameters(new Object[]{this.source});
            LOGGER.log(lr);
        }
    }

    public MetricSet toMetricSet() {
        LinkedHashMap<String, Metric> metrics = new LinkedHashMap<String, Metric>(2);
        metrics.put("value", (Metric)this.source);
        metrics.put("history", (Metric)this);
        return new GaugeHistogramMetricSet(metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoSamplingHistogram{");
        sb.append("source=").append(this.source);
        sb.append('}');
        return sb.toString();
    }

    private static class GaugeHistogramMetricSet
    implements MetricSet {
        private final Map<String, Metric> metrics;

        public GaugeHistogramMetricSet(Map<String, Metric> metrics) {
            this.metrics = metrics;
        }

        public Map<String, Metric> getMetrics() {
            return this.metrics;
        }
    }

    @Extension
    public static class PeriodicWorkImpl
    extends PeriodicWork {
        private final Map<Histogram, Long> lastWarning = new WeakHashMap<Histogram, Long>();

        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(15L);
        }

        protected synchronized void doRun() throws Exception {
            MetricRegistry registry = Metrics.metricRegistry();
            for (Histogram histogram : registry.getHistograms().values()) {
                LogRecord lr;
                if (!(histogram instanceof AutoSamplingHistogram)) continue;
                try {
                    ((AutoSamplingHistogram)histogram).update();
                }
                catch (Exception e) {
                    Long lw = this.lastWarning.get(histogram);
                    boolean warn = lw == null || lw + TimeUnit.HOURS.toMillis(1L) < System.currentTimeMillis();
                    LogRecord lr2 = new LogRecord(warn ? Level.WARNING : Level.FINE, "Uncaught exception when calling update for {0}");
                    lr2.setParameters(new Object[]{histogram});
                    lr2.setThrown(e);
                    LOGGER.log(lr2);
                    if (!warn) continue;
                    this.lastWarning.put(histogram, System.currentTimeMillis());
                }
                catch (Error e) {
                    lr = new LogRecord(Level.WARNING, "Error encountered while attempting to update {0}");
                    lr.setParameters(new Object[]{histogram});
                    lr.setThrown(e);
                    LOGGER.log(lr);
                    throw e;
                }
                catch (Throwable t) {
                    lr = new LogRecord(Level.SEVERE, "Uncaught throwable when calling update for {0}");
                    lr.setParameters(new Object[]{histogram});
                    lr.setThrown(t);
                    LOGGER.log(lr);
                }
            }
        }

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        @Restricted(value={DoNotUse.class})
        public static void dynamicInstallHack() {
            PeriodicWork p;
            VersionNumber version;
            if (Jenkins.getInstance().getInitLevel() == InitMilestone.COMPLETED && (version = Jenkins.getVersion()) != null && version.isOlderThan(new VersionNumber("2.129")) && (p = (PeriodicWork)ExtensionList.lookup(PeriodicWork.class).get(PeriodicWorkImpl.class)) != null) {
                Timer.get().scheduleAtFixedRate((Runnable)p, p.getInitialDelay(), p.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

