/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.PluginManager;
import hudson.PluginWrapper;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import jenkins.metrics.api.MetricProvider;
import jenkins.model.Jenkins;

@Extension
public class JenkinsVersionsProviderImpl
extends MetricProvider {
    private MetricSet set;
    private volatile long nextRefresh = Long.MIN_VALUE;

    @Override
    @NonNull
    public MetricSet getMetricSet() {
        if (this.set == null || this.nextRefresh < System.currentTimeMillis()) {
            LinkedHashMap<String, Metric> metrics = new LinkedHashMap<String, Metric>();
            metrics.put(MetricRegistry.name((String)"jenkins", (String[])new String[]{"versions", "core"}), (Metric)new VersionGauge(Jenkins.VERSION));
            Jenkins jenkins = Jenkins.getInstance();
            PluginManager pluginManager = jenkins.getPluginManager();
            for (PluginWrapper p : pluginManager.getPlugins()) {
                if (!p.isActive()) continue;
                metrics.put(MetricRegistry.name((String)"jenkins", (String[])new String[]{"versions", "plugin", p.getShortName()}), (Metric)new VersionGauge(p.getVersion()));
            }
            this.set = JenkinsVersionsProviderImpl.metrics(metrics);
            this.nextRefresh = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(15L);
        }
        return this.set;
    }

    private static class VersionGauge
    implements Gauge<String> {
        private final String version;

        public VersionGauge(String v) {
            int idx;
            this.version = v == null ? "?" : ((idx = v.indexOf(32)) == -1 ? v : v.substring(0, idx));
        }

        public String getValue() {
            return this.version;
        }
    }
}

