/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class NameRewriterMetricRegistry
extends MetricRegistry {
    private final MetricRegistry delegate;
    private final String prefix;
    private final String postfix;
    private final boolean wrap;

    public NameRewriterMetricRegistry(String prefix, MetricRegistry delegate, String postfix) {
        this(prefix, delegate, postfix, false);
    }

    public NameRewriterMetricRegistry(String prefix, MetricRegistry delegate, String postfix, boolean wrap) {
        this.prefix = prefix;
        this.delegate = delegate;
        this.postfix = postfix;
        this.wrap = wrap;
    }

    private <T> SortedMap<String, T> rewrite(SortedMap<String, T> original) {
        if (StringUtils.isBlank((CharSequence)this.prefix) && StringUtils.isBlank((CharSequence)this.postfix)) {
            return original;
        }
        TreeMap<String, T> result = new TreeMap<String, T>(original.comparator());
        for (Map.Entry<String, T> entry : original.entrySet()) {
            result.put(NameRewriterMetricRegistry.name((String)this.prefix, (String[])new String[]{entry.getKey(), this.postfix}), entry.getValue());
        }
        return result;
    }

    private <T> Map<String, T> rewrite(Map<String, T> original) {
        if (StringUtils.isBlank((CharSequence)this.prefix) && StringUtils.isBlank((CharSequence)this.postfix)) {
            return original;
        }
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(original.size());
        for (Map.Entry<String, T> entry : original.entrySet()) {
            result.put(NameRewriterMetricRegistry.name((String)this.prefix, (String[])new String[]{entry.getKey(), this.postfix}), entry.getValue());
        }
        return result;
    }

    private <T> SortedSet<String> rewrite(SortedSet<String> original) {
        if (StringUtils.isBlank((CharSequence)this.prefix) && StringUtils.isBlank((CharSequence)this.postfix)) {
            return original;
        }
        TreeSet<String> result = new TreeSet<String>(original.comparator());
        for (String name : original) {
            result.add(NameRewriterMetricRegistry.name((String)this.prefix, (String[])new String[]{name, this.postfix}));
        }
        return result;
    }

    private MetricFilter wrap(MetricFilter filter) {
        if (!this.wrap || StringUtils.isBlank((CharSequence)this.prefix) && StringUtils.isBlank((CharSequence)this.postfix)) {
            return filter;
        }
        return new WrappedMetricFilter(filter);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.rewrite(this.delegate.getCounters());
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.rewrite(this.delegate.getCounters(this.wrap(filter)));
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.rewrite(this.delegate.getGauges());
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.rewrite(this.delegate.getGauges(this.wrap(filter)));
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.rewrite(this.delegate.getHistograms());
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.rewrite(this.delegate.getHistograms(this.wrap(filter)));
    }

    public SortedMap<String, Meter> getMeters() {
        return this.rewrite(this.delegate.getMeters());
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.rewrite(this.delegate.getMeters(this.wrap(filter)));
    }

    public Map<String, Metric> getMetrics() {
        return this.rewrite(this.delegate.getMetrics());
    }

    public SortedSet<String> getNames() {
        return this.rewrite(this.delegate.getNames());
    }

    public SortedMap<String, Timer> getTimers() {
        return this.rewrite(this.delegate.getTimers());
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.rewrite(this.delegate.getTimers(this.wrap(filter)));
    }

    public Timer timer(String name) {
        throw new UnsupportedOperationException();
    }

    public void removeMatching(MetricFilter filter) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(MetricRegistryListener listener) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(String name) {
        throw new UnsupportedOperationException();
    }

    public void registerAll(MetricSet metrics) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Meter meter(String name) {
        throw new UnsupportedOperationException();
    }

    public Histogram histogram(String name) {
        throw new UnsupportedOperationException();
    }

    public Counter counter(String name) {
        throw new UnsupportedOperationException();
    }

    public void addListener(MetricRegistryListener listener) {
        throw new UnsupportedOperationException();
    }

    private final class WrappedMetricFilter
    implements MetricFilter {
        private final MetricFilter filter;

        public WrappedMetricFilter(MetricFilter filter) {
            this.filter = filter;
        }

        public boolean matches(String name, Metric metric) {
            return this.filter.matches(MetricRegistry.name((String)NameRewriterMetricRegistry.this.prefix, (String[])new String[]{name, NameRewriterMetricRegistry.this.postfix}), metric);
        }
    }
}

