/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.util;

import com.codahale.metrics.health.HealthCheckRegistry;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class HealthChecksThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = Logger.getLogger(HealthChecksThreadPool.class.getName());
    private static final int MAX_THREAD_POOL_SIZE = Integer.parseInt(System.getProperty(HealthChecksThreadPool.class.getName() + ".maxThreadNumber", "4"));
    private static AtomicLong rejectedExecutions = new AtomicLong(0L);
    private HealthCheckRegistry healthCheckRegistry;

    public HealthChecksThreadPool(HealthCheckRegistry healthCheckRegistry) {
        super(MAX_THREAD_POOL_SIZE, MAX_THREAD_POOL_SIZE, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new ExceptionCatchingThreadFactory((ThreadFactory)new DaemonThreadFactory(new ThreadFactory(){
            private final AtomicInteger number = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Metrics-HealthChecks-" + this.number.incrementAndGet());
            }
        })), new MetricsRejectedExecutionHandler(healthCheckRegistry));
        this.allowCoreThreadTimeOut(true);
        this.healthCheckRegistry = healthCheckRegistry;
        LOGGER.log(Level.FINE, "Created thread pool with a max of {0} threads (plus {1} in queue) for {2} health checks", new Object[]{this.getMaximumPoolSize(), Math.max(0, healthCheckRegistry.getNames().size() + 1 - this.getMaximumPoolSize()), healthCheckRegistry.getNames().size()});
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        int size = this.getQueue().size();
        int running = this.getActiveCount();
        SortedSet names = this.healthCheckRegistry.getNames();
        int limit = names.size();
        LOGGER.log(Level.FINER, "Executing health check, active={0} queued={1} thread pool={2} (max {3}) for {4} health checks: {5}", new Object[]{running, size, this.getPoolSize(), this.getMaximumPoolSize(), limit, names});
        if (running + size > limit + 1) {
            HealthChecksThreadPool.dropOldestInQueue(this, this.healthCheckRegistry);
        }
        super.beforeExecute(t, r);
    }

    static void dropOldestInQueue(ThreadPoolExecutor executor, HealthCheckRegistry healthCheckRegistry) {
        Object[] params = new Object[]{executor, executor.getQueue().size(), healthCheckRegistry.getNames(), healthCheckRegistry.getNames().size(), Arrays.asList(executor.getQueue().toArray())};
        Runnable discarded = (Runnable)executor.getQueue().poll();
        if (discarded != null) {
            LOGGER.log(Level.WARNING, "Too many health check executions queued, dropping oldest one. This may mean some health checks are taking too long to execute: {0}, queue size={1}, health checks={2} ({3}) {4}", params);
            HealthChecksThreadPool.cancelQueuedHealthCheck(discarded);
        }
    }

    private static void cancelQueuedHealthCheck(Runnable discarded) {
        if (discarded instanceof Future) {
            ((Future)((Object)discarded)).cancel(false);
        } else {
            LOGGER.log(Level.WARNING, "HealthCheck Runnable is not an instance of Future: {0}", discarded);
        }
    }

    @Restricted(value={DoNotUse.class})
    public static long getRejectedExecutions() {
        return rejectedExecutions.get();
    }

    private static class MetricsRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private HealthCheckRegistry healthCheckRegistry;

        public MetricsRejectedExecutionHandler(HealthCheckRegistry healthCheckRegistry) {
            this.healthCheckRegistry = healthCheckRegistry;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            rejectedExecutions.incrementAndGet();
            if (!executor.isShutdown()) {
                LOGGER.log(Level.WARNING, "Execution of health check was rejected: {0}, queue size={1}, health checks={2} ({3})", new Object[]{executor, executor.getQueue().size(), this.healthCheckRegistry.getNames(), this.healthCheckRegistry.getNames().size()});
                HealthChecksThreadPool.dropOldestInQueue(executor, this.healthCheckRegistry);
                executor.execute(r);
            }
        }
    }
}

