/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.net;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.codegist.common.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Urls {
    private static final Pattern EQUAL = Pattern.compile("=");

    private Urls() {
        throw new IllegalStateException();
    }

    public static String encode(String value, Charset encoding) throws UnsupportedEncodingException {
        String encoded = URLEncoder.encode(value, encoding.displayName());
        StringBuilder sb = new StringBuilder(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                sb.append("%2A");
                continue;
            }
            if (focus == '+') {
                sb.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                sb.append('~');
                i += 2;
                continue;
            }
            sb.append(focus);
        }
        return sb.toString();
    }

    public static Map<String, String> parseQueryString(URI uri) {
        return Urls.parseQueryString(uri, Charset.defaultCharset());
    }

    public static Map<String, String> parseQueryString(String queryString) {
        return Urls.parseQueryString(queryString, Charset.defaultCharset());
    }

    public static Map<String, String> parseQueryString(URI uri, Charset encoding) {
        String qs = Objects.defaultIfNull(uri.getRawQuery(), "");
        return Urls.parseQueryString(qs, encoding);
    }

    public static Map<String, String> parseQueryString(String queryString, Charset encoding) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Scanner scanner = new Scanner(queryString).useDelimiter("&");
        while (scanner.hasNext()) {
            String[] nameValue = EQUAL.split(scanner.next());
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("Invalid parameter!");
            }
            String name = Urls.decode(nameValue[0], encoding);
            String value = null;
            if (nameValue.length == 2) {
                value = Urls.decode(nameValue[1], encoding);
            }
            params.put(name, value);
        }
        return params;
    }

    public static String getQueryString(String url) {
        int len = url.length();
        int query = url.indexOf(63) + 1;
        if (query != 0 && query < len) {
            return url.substring(query, len);
        }
        return null;
    }

    public static String decode(String content, Charset encoding) {
        try {
            return URLDecoder.decode(content, encoding.displayName());
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static boolean hasQueryString(String url) {
        int index = url.indexOf(63);
        return index != -1 && index < url.length();
    }

    public static String normalizeSlashes(String url) {
        String server;
        String pUrl = url;
        String queryString = null;
        if (Urls.hasQueryString(pUrl)) {
            int questionMark = pUrl.indexOf(63);
            queryString = pUrl.substring(questionMark);
            pUrl = pUrl.substring(0, questionMark);
        }
        int sepP = pUrl.indexOf("://");
        int sepPEnd = sepP + 3;
        int firstSlash = pUrl.indexOf(47, sepPEnd);
        String protocol = pUrl.substring(0, sepP);
        if (firstSlash > -1) {
            server = pUrl.substring(sepPEnd, firstSlash);
            pUrl = pUrl.substring(firstSlash);
        } else {
            server = pUrl.substring(sepPEnd);
            pUrl = "";
        }
        StringBuilder urlsb = new StringBuilder().append(protocol).append("://").append(server);
        if (pUrl.length() > 1) {
            char pre = pUrl.charAt(0);
            urlsb.append(pre);
            for (int i = 1; i < pUrl.length(); ++i) {
                char c = pUrl.charAt(i);
                if (pre != '/' || c != '/') {
                    urlsb.append(c);
                }
                pre = c;
            }
        } else if (pUrl.length() > 0) {
            urlsb.append(pUrl);
        }
        if (queryString != null) {
            return urlsb.append(queryString).toString();
        }
        return urlsb.toString();
    }
}

