/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import java.io.Serializable;
import org.codegist.common.log.AbstractLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends AbstractLogger
implements Serializable {
    private final transient Logger logger;

    public Slf4jLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    protected void logError(Object message, Throwable e) {
        this.logger.error(String.valueOf(message), e);
    }

    protected void logError(Object message) {
        this.logger.error(String.valueOf(message));
    }

    protected void logWarn(Object message, Throwable e) {
        this.logger.warn(String.valueOf(message), e);
    }

    protected void logWarn(Object message) {
        this.logger.warn(String.valueOf(message));
    }

    protected void logInfo(Object message, Throwable e) {
        this.logger.info(String.valueOf(message), e);
    }

    protected void logInfo(Object message) {
        this.logger.info(String.valueOf(message));
    }

    protected void logDebug(Object message, Throwable e) {
        this.logger.debug(String.valueOf(message), e);
    }

    protected void logDebug(Object message) {
        this.logger.debug(String.valueOf(message));
    }

    protected void logTrace(Object message, Throwable e) {
        this.logger.trace(String.valueOf(message), e);
    }

    protected void logTrace(Object message) {
        this.logger.trace(String.valueOf(message));
    }

    public boolean isErrorOn() {
        return this.logger.isErrorEnabled();
    }

    public boolean isWarnOn() {
        return this.logger.isWarnEnabled();
    }

    public boolean isInfoOn() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugOn() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceOn() {
        return this.logger.isTraceEnabled();
    }
}

