/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codegist.common.log.ApacheCommonsLogger;
import org.codegist.common.log.Log4jLogger;
import org.codegist.common.log.LogCatLogger;
import org.codegist.common.log.LoggerFactory;
import org.codegist.common.log.NoOpLogger;
import org.codegist.common.log.Slf4jLogger;
import org.codegist.common.reflect.Classes;

final class LoggerProvider {
    static final String LOGGER_CLASS_PROP = "org.codegist.common.log.class";
    private static final LoggerFactory DEFAULT_FACTORY = new LoggerFactory(NoOpLogger.class);
    private static final Map<String, LoggerFactory> LOGGER_FACTORIES = new LinkedHashMap<String, LoggerFactory>(){
        {
            this.put("android.util.Log", new LoggerFactory(LogCatLogger.class));
            this.put("org.apache.log4j.Logger", new LoggerFactory(Log4jLogger.class));
            this.put("org.slf4j.LoggerFactory", new LoggerFactory(Slf4jLogger.class));
            this.put("org.apache.commons.logging.LogFactory", new LoggerFactory(ApacheCommonsLogger.class));
        }
    };

    private LoggerProvider() {
    }

    static LoggerFactory getAvailableLoggerFactory() {
        ClassLoader cloader = LoggerProvider.class.getClassLoader();
        return LoggerProvider.getAvailableLoggerFactory(cloader);
    }

    static LoggerFactory getAvailableLoggerFactory(ClassLoader loader) {
        if (System.getProperty(LOGGER_CLASS_PROP) != null) {
            try {
                return new LoggerFactory(Class.forName(System.getProperty(LOGGER_CLASS_PROP)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry<String, LoggerFactory> entry : LOGGER_FACTORIES.entrySet()) {
            if (!Classes.isClassKnown(entry.getKey(), loader)) continue;
            return entry.getValue();
        }
        return DEFAULT_FACTORY;
    }
}

