/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import org.codegist.common.log.Logger;

public abstract class AbstractLogger
extends Logger {
    private String format(String format, Object ... args) {
        return args.length > 0 ? String.format(format, args) : format;
    }

    protected abstract void logError(Object var1, Throwable var2);

    protected abstract void logError(Object var1);

    public void error(Throwable error) {
        try {
            if (!this.isErrorOn()) {
                return;
            }
            this.logError(error.getMessage(), error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void error(Throwable e, String format, Object ... args) {
        try {
            if (!this.isErrorOn()) {
                return;
            }
            this.logError(this.format(format, args), e);
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
    }

    public void error(Throwable e, Object message) {
        try {
            if (!this.isErrorOn()) {
                return;
            }
            this.logError(message, e);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void error(String format, Object ... args) {
        try {
            if (!this.isErrorOn()) {
                return;
            }
            this.logError(this.format(format, args));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void error(Object message) {
        try {
            if (!this.isErrorOn()) {
                return;
            }
            this.logError(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected abstract void logWarn(Object var1, Throwable var2);

    protected abstract void logWarn(Object var1);

    public void warn(Throwable e, String format, Object ... args) {
        try {
            if (!this.isWarnOn()) {
                return;
            }
            this.logWarn(this.format(format, args), e);
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
    }

    public void warn(Throwable e, Object message) {
        try {
            if (!this.isWarnOn()) {
                return;
            }
            this.logWarn(message, e);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void warn(String format, Object ... args) {
        try {
            if (!this.isWarnOn()) {
                return;
            }
            this.logWarn(this.format(format, args));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void warn(Object message) {
        try {
            if (!this.isWarnOn()) {
                return;
            }
            this.logWarn(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void warn(Throwable error) {
        try {
            if (!this.isWarnOn()) {
                return;
            }
            this.logWarn(error.getMessage(), error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected abstract void logInfo(Object var1, Throwable var2);

    protected abstract void logInfo(Object var1);

    public void info(Throwable e, String format, Object ... args) {
        try {
            if (!this.isInfoOn()) {
                return;
            }
            this.logInfo(this.format(format, args), e);
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
    }

    public void info(Throwable e, Object message) {
        try {
            if (!this.isInfoOn()) {
                return;
            }
            this.logInfo(message, e);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void info(String format, Object ... args) {
        try {
            if (!this.isInfoOn()) {
                return;
            }
            this.logInfo(this.format(format, args));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void info(Object message) {
        try {
            if (!this.isInfoOn()) {
                return;
            }
            this.logInfo(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void info(Throwable error) {
        try {
            if (!this.isInfoOn()) {
                return;
            }
            this.logInfo(error.getMessage(), error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected abstract void logDebug(Object var1, Throwable var2);

    protected abstract void logDebug(Object var1);

    public void debug(Throwable e, String format, Object ... args) {
        try {
            if (!this.isDebugOn()) {
                return;
            }
            this.logDebug(this.format(format, args), e);
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
    }

    public void debug(Throwable e, Object message) {
        try {
            if (!this.isDebugOn()) {
                return;
            }
            this.logDebug(message, e);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void debug(String format, Object ... args) {
        try {
            if (!this.isDebugOn()) {
                return;
            }
            this.logDebug(this.format(format, args));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void debug(Object message) {
        try {
            if (!this.isDebugOn()) {
                return;
            }
            this.logDebug(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void debug(Throwable error) {
        try {
            if (!this.isDebugOn()) {
                return;
            }
            this.logDebug(error.getMessage(), error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected abstract void logTrace(Object var1, Throwable var2);

    protected abstract void logTrace(Object var1);

    public void trace(Throwable e, String format, Object ... args) {
        try {
            if (!this.isTraceOn()) {
                return;
            }
            this.logTrace(this.format(format, args), e);
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
    }

    public void trace(Throwable e, Object message) {
        try {
            if (!this.isTraceOn()) {
                return;
            }
            this.logTrace(message, e);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void trace(String format, Object ... args) {
        try {
            if (!this.isTraceOn()) {
                return;
            }
            this.logTrace(this.format(format, args));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void trace(Object message) {
        try {
            if (!this.isTraceOn()) {
                return;
            }
            this.logTrace(message);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void trace(Throwable error) {
        try {
            if (!this.isTraceOn()) {
                return;
            }
            this.logTrace(error.getMessage(), error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

