/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.codegist.common.collect.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Objects {
    private Objects() {
        throw new IllegalStateException();
    }

    public static <T> T defaultIfNull(T o, T def) {
        return o != null ? o : def;
    }

    public static String toString(Object o, String defaultIfNull) {
        return o != null ? o.toString() : defaultIfNull;
    }

    public static <T> Collection<T> asCollection(T o) {
        if (o == null) {
            return java.util.Collections.emptyList();
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o.getClass().isArray()) {
            ArrayList col = new ArrayList();
            ArrayIterator iter = new ArrayIterator(o);
            while (iter.hasNext()) {
                col.add(iter.next());
            }
            return col;
        }
        return java.util.Collections.singleton(o);
    }

    public static <T> Iterator<T> iterate(Object o) {
        if (o == null) {
            return Collections.EMPTY_ITERATOR;
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o.getClass().isArray()) {
            return new ArrayIterator(o);
        }
        return new SingletonIterator(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final Object array;
        private final int length;
        private int index = 0;

        private ArrayIterator(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public T next() {
            return (T)Array.get(this.array, this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator<T>
    implements Iterator<T> {
        private final AtomicReference<Object> ref;

        private SingletonIterator(Object value) {
            this.ref = new AtomicReference<Object>(value);
        }

        @Override
        public boolean hasNext() {
            return this.ref.get() != null;
        }

        @Override
        public T next() {
            return this.ref.getAndSet(null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

