/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.lang;

import org.codegist.common.lang.Validate;

public class HashCodeBuilder {
    private final int constant;
    private int hashcode = 0;

    public HashCodeBuilder() {
        this(37, 17);
    }

    public HashCodeBuilder(int hashcode, int constant) {
        Validate.isTrue(constant != 0, "constant must be non zero", new Object[0]);
        Validate.isTrue(hashcode != 0, "initial hashcode must be non zero", new Object[0]);
        Validate.isTrue(constant % 2 != 0, "initial constant must be an odd value", new Object[0]);
        Validate.isTrue(hashcode % 2 != 0, "initial hashcode must be an odd value", new Object[0]);
        this.constant = constant;
        this.hashcode = hashcode;
    }

    public HashCodeBuilder append(int value) {
        this.hashcode = this.hashcode * this.constant + value;
        return this;
    }

    public HashCodeBuilder append(short value) {
        this.hashcode = this.hashcode * this.constant + value;
        return this;
    }

    public HashCodeBuilder append(char value) {
        this.hashcode = this.hashcode * this.constant + value;
        return this;
    }

    public HashCodeBuilder append(byte value) {
        this.hashcode = this.hashcode * this.constant + value;
        return this;
    }

    public HashCodeBuilder append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    public HashCodeBuilder append(float value) {
        this.hashcode = this.hashcode * this.constant + Float.floatToIntBits(value);
        return this;
    }

    public HashCodeBuilder append(long value) {
        this.hashcode = this.hashcode * this.constant + (int)(value ^ value >> 32);
        return this;
    }

    public HashCodeBuilder append(boolean value) {
        this.hashcode = this.hashcode * this.constant + (value ? 0 : 1);
        return this;
    }

    public HashCodeBuilder append(Object[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(long[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(int[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(short[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(char[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(byte[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(double[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(float[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(boolean[] array) {
        if (array == null) {
            return this.appendNull();
        }
        for (int i = 0; i < array.length; ++i) {
            this.append(array[i]);
        }
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.appendNull();
        } else if (!object.getClass().isArray()) {
            this.hashcode = this.hashcode * this.constant + object.hashCode();
        } else if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
        return this;
    }

    private HashCodeBuilder appendNull() {
        this.hashcode *= this.constant;
        return this;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public HashCodeBuilder appendSuper(int i) {
        return this.append(i);
    }
}

