/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public final class IOs {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOs() {
        throw new IllegalStateException();
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOs.toString(new InputStreamReader(inputStream), false);
    }

    public static String toString(InputStream inputStream, boolean close) throws IOException {
        return IOs.toString(new InputStreamReader(inputStream), close);
    }

    public static String toString(InputStream inputStream, String charset) throws IOException {
        return IOs.toString(inputStream, Charset.forName(charset), false);
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        return IOs.toString(new InputStreamReader(inputStream, charset));
    }

    public static String toString(InputStream inputStream, String charset, boolean close) throws IOException {
        return IOs.toString(inputStream, Charset.forName(charset), close);
    }

    public static String toString(InputStream inputStream, Charset charset, boolean close) throws IOException {
        return IOs.toString(new InputStreamReader(inputStream, charset), close);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOs.toByteArray(inputStream, false);
    }

    public static byte[] toByteArray(InputStream inputStream, boolean close) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOs.copy(inputStream, out, close);
        return out.toByteArray();
    }

    public static String toString(Reader reader) throws IOException {
        return IOs.toString(reader, false);
    }

    public static String toString(Reader reader, boolean close) throws IOException {
        StringWriter out = new StringWriter();
        IOs.copy(reader, out, close);
        return out.toString();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOs.copy(in, out, false);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IOs.copy(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out, boolean close) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, Writer out, boolean close) throws IOException {
        try {
            int n;
            char[] buffer = new char[4096];
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public static void close(InputStream inputStream) {
        IOs.close((Closeable)inputStream);
    }

    public static void close(Reader reader) {
        IOs.close((Closeable)reader);
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

