/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codegist.common.lang.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Placeholders {
    private static final Pattern ESCAPED_OPEN_CURLY_BRACKET = Pattern.compile(Pattern.quote("\\{"));
    private static final Pattern ESCAPED_CLOSE_CURLY_BRACKET = Pattern.compile(Pattern.quote("\\}"));

    private Placeholders() {
        throw new IllegalStateException();
    }

    public static Map<Pattern, String> compile(Map<String, String> placeholders) {
        HashMap<Pattern, String> compiled = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String placeholder = entry.getKey();
            String value = entry.getValue();
            compiled.put(Pattern.compile("\\{" + Pattern.quote(placeholder) + "\\}"), value);
        }
        return Collections.unmodifiableMap(compiled);
    }

    public static String merge(Map<Pattern, String> placeholders, String str) {
        if (Strings.isBlank(str)) {
            return str;
        }
        String replaced = str;
        for (Map.Entry<Pattern, String> entry : placeholders.entrySet()) {
            Pattern placeholder = entry.getKey();
            String value = entry.getValue();
            replaced = placeholder.matcher(replaced).replaceAll(value);
        }
        replaced = ESCAPED_OPEN_CURLY_BRACKET.matcher(replaced).replaceAll("{");
        replaced = ESCAPED_CLOSE_CURLY_BRACKET.matcher(replaced).replaceAll("}");
        return replaced;
    }
}

