/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codegist.common.io.StringBuilderWriter;
import org.codegist.common.net.Urls;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.SimpleEncodedPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pairs {
    private static final Pattern AMP = Pattern.compile("&");
    private static final Pattern EQUAL = Pattern.compile("=");
    private static final Comparator<EncodedPair> PAIR_NAME_VALUE_COMPARATOR = new Comparator<EncodedPair>(){

        @Override
        public int compare(EncodedPair o1, EncodedPair o2) {
            int i = o1.getName().compareTo(o2.getName());
            return i != 0 ? i : o1.getValue().compareTo(o2.getValue());
        }
    };

    private Pairs() {
        throw new IllegalStateException();
    }

    public static EncodedPair toPreEncodedPair(String name, String value) {
        return new SimpleEncodedPair(name, value);
    }

    public static EncodedPair toPair(String nameToEncode, String valueToEncode, Charset charset) throws UnsupportedEncodingException {
        return Pairs.toPair(nameToEncode, valueToEncode, charset, false);
    }

    public static EncodedPair toPair(String name, String value, Charset charset, boolean encoded) throws UnsupportedEncodingException {
        String valueEncoded;
        String nameEncoded;
        if (encoded) {
            nameEncoded = name;
            valueEncoded = value;
        } else {
            nameEncoded = Urls.encode(name, charset);
            valueEncoded = Urls.encode(value, charset);
        }
        return new SimpleEncodedPair(nameEncoded, valueEncoded);
    }

    public static List<EncodedPair> fromUrlEncoded(String urlEncoded) {
        String[] split;
        ArrayList<EncodedPair> pairs = new ArrayList<EncodedPair>();
        for (String param : split = AMP.split(urlEncoded)) {
            String[] paramSplit = EQUAL.split(param);
            pairs.add(Pairs.toPreEncodedPair(paramSplit[0], paramSplit[1]));
        }
        return pairs;
    }

    public static List<EncodedPair> sortByNameAndValues(List<? extends EncodedPair> pairs) {
        ArrayList<EncodedPair> sorted = new ArrayList<EncodedPair>(pairs);
        Collections.sort(sorted, PAIR_NAME_VALUE_COMPARATOR);
        return sorted;
    }

    public static String join(List<? extends EncodedPair> pairs, char pairSep) {
        return Pairs.join(pairs, pairSep, '=', false, false);
    }

    public static String join(List<? extends EncodedPair> pairs, char pairSep, char nameValSep) {
        return Pairs.join(pairs, pairSep, nameValSep, false, false);
    }

    public static String join(List<? extends EncodedPair> pairs, char pairSep, char nameValSep, boolean quoteName, boolean quoteVal) {
        return Pairs.join(pairs.iterator(), pairSep, nameValSep, quoteName, quoteVal);
    }

    public static String join(Iterator<? extends EncodedPair> pairs, char pairSep) {
        return Pairs.join(pairs, pairSep, '=', false, false);
    }

    public static String join(Iterator<? extends EncodedPair> pairs, char pairSep, char nameValSep) {
        return Pairs.join(pairs, pairSep, nameValSep, false, false);
    }

    public static String join(Iterator<? extends EncodedPair> pairs, char pairSep, char nameValSep, boolean quoteName, boolean quoteVal) {
        StringBuilderWriter sw = new StringBuilderWriter();
        try {
            Pairs.join((Writer)sw, pairs, pairSep, nameValSep, quoteName, quoteVal);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)sw).toString();
    }

    public static void join(Writer writer, List<? extends EncodedPair> pairs, char pairSep) throws IOException {
        Pairs.join(writer, pairs, pairSep, '=', false, false);
    }

    public static void join(Writer writer, List<? extends EncodedPair> pairs, char pairSep, char nameValSep) throws IOException {
        Pairs.join(writer, pairs, pairSep, nameValSep, false, false);
    }

    public static void join(Writer writer, List<? extends EncodedPair> pairs, char pairSep, char nameValSep, boolean quoteName, boolean quoteVal) throws IOException {
        Pairs.join(writer, pairs.iterator(), pairSep, nameValSep, quoteName, quoteVal);
    }

    public static void join(Writer writer, Iterator<? extends EncodedPair> pairs, char pairSep) throws IOException {
        Pairs.join(writer, pairs, pairSep, '=', false, false);
    }

    public static void join(Writer writer, Iterator<? extends EncodedPair> pairs, char pairSep, char nameValSep) throws IOException {
        Pairs.join(writer, pairs, pairSep, nameValSep, false, false);
    }

    public static void join(Writer writer, Iterator<? extends EncodedPair> pairs, char pairSep, char nameValSep, boolean quoteName, boolean quoteVal) throws IOException {
        boolean first = true;
        while (pairs.hasNext()) {
            EncodedPair httpEncodedPair = pairs.next();
            if (!first) {
                writer.append(pairSep);
            }
            if (quoteName) {
                writer.append('\"').append(httpEncodedPair.getName()).append('\"');
            } else {
                writer.append(httpEncodedPair.getName());
            }
            writer.append(nameValSep);
            if (quoteVal) {
                writer.append('\"').append(httpEncodedPair.getValue()).append('\"');
            } else {
                writer.append(httpEncodedPair.getValue());
            }
            first = false;
        }
    }
}

