/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.util;

import java.util.HashMap;
import java.util.Map;
import org.codegist.common.lang.Strings;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.param.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiParts {
    private static final String CONTENT_TYPE = "multipart.content-type";
    private static final String FILENAME = "multipart.filename";
    private static final String MULTIPART_FLAG = "multipart.flag";

    private MultiParts() {
        throw new IllegalStateException();
    }

    public static String getContentType(ParamConfig paramConfig) {
        return (String)paramConfig.getMetaDatas().get(CONTENT_TYPE);
    }

    public static String getFileName(ParamConfig paramConfig) {
        return (String)paramConfig.getMetaDatas().get(FILENAME);
    }

    public static String getContentType(Param param) {
        return MultiParts.getContentType(param.getParamConfig());
    }

    public static String getFileName(Param param) {
        return MultiParts.getFileName(param.getParamConfig());
    }

    public static boolean hasMultiPart(ParamConfig[] paramConfigs) {
        for (ParamConfig cfg : paramConfigs) {
            if (!MultiParts.hasMultiPart(cfg.getMetaDatas())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMultiPart(Map<String, Object> metadatas) {
        return metadatas.containsKey(MULTIPART_FLAG);
    }

    public static boolean hasMultiPart(Param param) {
        return MultiParts.hasMultiPart(param.getParamConfig().getMetaDatas());
    }

    public static void putMetaDatas(Map<String, Object> metadatas, String contentType, String fileName) {
        metadatas.put(MULTIPART_FLAG, true);
        if (Strings.isNotBlank(contentType)) {
            metadatas.put(CONTENT_TYPE, contentType);
        }
        if (Strings.isNotBlank(fileName)) {
            metadatas.put(FILENAME, fileName);
        }
    }

    public static Map<String, Object> toMetaDatas(String contentType, String fileName) {
        HashMap<String, Object> metadatas = new HashMap<String, Object>();
        MultiParts.putMetaDatas(metadatas, contentType, fileName);
        return metadatas;
    }

    public static void asMultipart(Map<String, Object> metadatas) {
        metadatas.put(MULTIPART_FLAG, true);
    }
}

