/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.CRestException;
import org.codegist.crest.util.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentRegistry<K, T> {
    private final Map<K, ItemDescriptor<T>> mapping;
    private final Map<K, T> cache = new HashMap<K, T>();
    private final ItemDescriptor<T> defaultIfNotFoundDescriptor;
    private final CRestConfig crestConfig;
    private T defaultIfNotFound;

    ComponentRegistry(Map<K, ItemDescriptor<T>> mapping, CRestConfig crestConfig, ItemDescriptor<T> defaultIfNotFoundDescriptor) {
        this.defaultIfNotFoundDescriptor = defaultIfNotFoundDescriptor;
        this.mapping = mapping;
        this.crestConfig = crestConfig;
    }

    public boolean contains(K key) {
        return this.mapping.containsKey(key);
    }

    public T get(K key) {
        T item = this.cache.get(key);
        if (item == null) {
            item = this.buildAndCache(key, this.crestConfig);
        }
        return item;
    }

    private synchronized T buildAndCache(K key, CRestConfig crestConfig) {
        T value;
        ItemDescriptor<T> item = this.mapping.get(key);
        if (item != null) {
            value = item.instanciate(crestConfig);
        } else if (this.defaultIfNotFound != null) {
            value = this.defaultIfNotFound;
        } else if (this.defaultIfNotFoundDescriptor != null) {
            this.defaultIfNotFound = this.defaultIfNotFoundDescriptor.instanciate(crestConfig);
            value = this.defaultIfNotFound;
        } else {
            throw new CRestException("No item bound to key: " + key);
        }
        this.cache.put(key, value);
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<K, T> {
        private final Map<K, ItemDescriptor<T>> mapping = new HashMap<K, ItemDescriptor<T>>();
        private ItemDescriptor<T> defaultIfNotFoundDescriptor;

        public ComponentRegistry<K, T> build(CRestConfig crestConfig) {
            return new ComponentRegistry<K, T>(this.mapping, crestConfig, this.defaultIfNotFoundDescriptor);
        }

        public Builder<K, T> register(Class<? extends T> item, K ... keys) {
            return this.register(item, keys, Collections.<String, Object>emptyMap());
        }

        public Builder<K, T> register(Class<? extends T> item, K[] keys, Map<String, Object> itemConfig) {
            ItemDescriptor<? extends T> descriptor = new ItemDescriptor<T>(item, itemConfig);
            for (K mt : keys) {
                this.mapping.put(mt, descriptor);
            }
            return this;
        }

        public Builder<K, T> register(Map<K, Class<? extends T>> mapping) {
            for (Map.Entry<K, Class<T>> e : mapping.entrySet()) {
                this.register(e.getValue(), e.getKey());
            }
            return this;
        }

        public Builder<K, T> defaultAs(Class<? extends T> item) {
            return this.defaultAs(item, Collections.<String, Object>emptyMap());
        }

        public Builder<K, T> defaultAs(Class<? extends T> item, Map<String, Object> itemConfig) {
            this.defaultIfNotFoundDescriptor = new ItemDescriptor<T>(item, itemConfig);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ItemDescriptor<T> {
        private final Class<? extends T> clazz;
        private final Map<String, Object> config;
        private final AtomicReference<T> instanceRef = new AtomicReference();

        ItemDescriptor(Class<? extends T> clazz, Map<String, Object> config) {
            this.clazz = clazz;
            this.config = config;
        }

        T instanciate(CRestConfig crestConfig) {
            T instance = this.instanceRef.get();
            if (instance != null) {
                return instance;
            }
            try {
                CRestConfig merged = this.config.isEmpty() ? crestConfig : crestConfig.merge(this.config);
                instance = ComponentFactory.instantiate(this.clazz, merged);
                this.instanceRef.set(instance);
                return instance;
            }
            catch (Exception e) {
                throw CRestException.handle(e);
            }
        }
    }
}

