/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codegist.crest.CRestConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentFactory {
    private ComponentFactory() {
        throw new IllegalStateException();
    }

    public static <T> T instantiate(Class<T> clazz, CRestConfig crestConfig) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        try {
            return ComponentFactory.accessible(clazz.getDeclaredConstructor(CRestConfig.class)).newInstance(crestConfig);
        }
        catch (NoSuchMethodException e) {
            return ComponentFactory.accessible(clazz.getDeclaredConstructor(new Class[0])).newInstance(new Object[0]);
        }
    }

    private static <T> Constructor<? extends T> accessible(Constructor<? extends T> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            AccessController.doPrivileged(new MakeAccessible(constructor));
        }
        return constructor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MakeAccessible
    implements PrivilegedAction<Constructor> {
        private final Constructor constructor;

        private MakeAccessible(Constructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public Constructor run() {
            this.constructor.setAccessible(true);
            return this.constructor;
        }
    }
}

