/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.simplexml;

import java.util.Date;
import java.util.HashMap;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.serializer.simplexml.BooleanMatcher;
import org.codegist.crest.serializer.simplexml.DateMatcher;
import org.codegist.crest.serializer.simplexml.MatcherRegistry;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimpleXmlFactory {
    static final String SERIALIZER = "#serializer";

    private SimpleXmlFactory() {
        throw new IllegalStateException();
    }

    static Serializer createSerializer(CRestConfig crestConfig, Class<?> source) {
        String prefix = source.getName();
        Serializer serializer = (Serializer)crestConfig.get(prefix + SERIALIZER);
        if (serializer != null) {
            return serializer;
        }
        HashMap<Class, Transform> registry = new HashMap<Class, Transform>();
        registry.put(Date.class, new DateMatcher(crestConfig.getDateFormat()));
        registry.put(Boolean.class, new BooleanMatcher(crestConfig.getBooleanTrue(), crestConfig.getBooleanFalse()));
        registry.put(Boolean.TYPE, (Transform)registry.get(Boolean.class));
        return new Persister((Matcher)new MatcherRegistry(registry));
    }
}

