/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.simplexml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.codegist.common.io.IOs;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.simplexml.SimpleXmlFactory;
import org.simpleframework.xml.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXmlDeserializer
implements Deserializer {
    private static final String PREFIX = SimpleXmlDeserializer.class.getName();
    private static final boolean DEFAULT_STRICT = true;
    public static final String STRICT_PROP = PREFIX + "#strict";
    public static final String SERIALIZER_PROP = PREFIX + "#serializer";
    private final boolean strict;
    private final Serializer serializer;

    public SimpleXmlDeserializer(CRestConfig crestConfig) {
        this.serializer = SimpleXmlFactory.createSerializer(crestConfig, this.getClass());
        this.strict = crestConfig.get(STRICT_PROP, Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> type, Type genericType, InputStream stream, Charset charset) throws Exception {
        try {
            Object object = this.serializer.read(type, (Reader)new InputStreamReader(stream, charset), this.strict);
            return (T)object;
        }
        finally {
            IOs.close(stream);
        }
    }
}

