/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.jaxb;

import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBException;
import org.codegist.common.reflect.Types;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.serializer.jaxb.Classes;
import org.codegist.crest.serializer.jaxb.Jaxb;
import org.codegist.crest.serializer.jaxb.JaxbFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeCachingJaxb
implements Jaxb {
    private final CRestConfig crestConfig;
    private final ConcurrentMap<Set<Class<?>>, Jaxb> cache = new ConcurrentHashMap();
    private final Class<?> source;

    TypeCachingJaxb(CRestConfig crestConfig, Class<?> source) {
        this.crestConfig = crestConfig;
        this.source = source;
    }

    @Override
    public <T> void marshal(T object, OutputStream out, Charset charset) throws Exception {
        Jaxb jaxb;
        if (object instanceof Classes) {
            Set<Class<?>> classes = ((Classes)object).getClasses();
            jaxb = this.get(classes);
        } else {
            jaxb = this.get(Collections.singleton(object.getClass()));
        }
        jaxb.marshal(object, out, charset);
    }

    @Override
    public <T> T unmarshal(Class<T> type, Type genericType, Reader reader) throws Exception {
        Set<Class<?>> classes = Types.getActors(genericType);
        classes.add(type);
        Jaxb jaxb = this.get(classes);
        return jaxb.unmarshal(type, genericType, reader);
    }

    private Jaxb get(Set<Class<?>> key) throws JAXBException {
        Jaxb jaxb = (Jaxb)this.cache.get(key);
        if (jaxb == null) {
            jaxb = JaxbFactory.create(this.crestConfig, this.source, key.toArray(new Class[key.size()]));
            Jaxb previousJaxb = this.cache.putIfAbsent(key, jaxb);
            jaxb = previousJaxb != null ? previousJaxb : jaxb;
        }
        return jaxb;
    }
}

