/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.jaxb;

import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.codegist.crest.CRestException;
import org.codegist.crest.serializer.jaxb.Jaxb;
import org.codegist.crest.serializer.jaxb.SimpleJaxb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PooledJaxb
implements Jaxb {
    private final BlockingQueue<Jaxb> pool;
    private final long maxWait;

    public PooledJaxb(JAXBContext jaxbContext, int poolSize, long maxWait) throws JAXBException {
        this.maxWait = maxWait;
        this.pool = new ArrayBlockingQueue<Jaxb>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            SimpleJaxb jaxb = new SimpleJaxb(jaxbContext);
            this.pool.add(jaxb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void marshal(T object, OutputStream out, Charset charset) throws Exception {
        Jaxb jaxb = this.borrow();
        try {
            jaxb.marshal(object, out, charset);
        }
        finally {
            this.lend(jaxb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unmarshal(Class<T> type, Type genericType, Reader reader) throws Exception {
        Jaxb jaxb = this.borrow();
        try {
            T t = jaxb.unmarshal(type, genericType, reader);
            return t;
        }
        finally {
            this.lend(jaxb);
        }
    }

    private void lend(Jaxb jaxb) {
        this.pool.offer(jaxb);
    }

    private Jaxb borrow() throws InterruptedException {
        Jaxb jaxb = this.pool.poll(this.maxWait, TimeUnit.MILLISECONDS);
        if (jaxb == null) {
            throw new CRestException("No jaxb could have been retrieved in the allowed time window");
        }
        return jaxb;
    }
}

