/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.serializer.jaxb.Jaxb;
import org.codegist.crest.serializer.jaxb.PooledJaxb;
import org.codegist.crest.serializer.jaxb.SimpleJaxb;
import org.codegist.crest.serializer.jaxb.TypeCachingJaxb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JaxbFactory {
    private static final Long DEFAULT_MAX_WAIT = 30000L;
    static final String POOL_RETRIEVAL_MAX_WAIT = "#pool.retrieval.max-wait";
    static final String JAXB = "#jaxb";
    static final String MODEL_PACKAGE = "#model.package";
    static final String MODEL_FACTORY_CLASS = "#model.factory-class";

    private JaxbFactory() {
        throw new IllegalStateException();
    }

    static Jaxb create(CRestConfig crestConfig, Class<?> source) throws JAXBException {
        String prefix = source.getName();
        Jaxb jaxb = (Jaxb)crestConfig.get(prefix + JAXB);
        if (jaxb != null) {
            return jaxb;
        }
        String modelPackage = (String)crestConfig.get(prefix + MODEL_PACKAGE);
        if (modelPackage != null) {
            return JaxbFactory.create(crestConfig, source, modelPackage);
        }
        Class modelFactory = (Class)crestConfig.get(prefix + MODEL_FACTORY_CLASS);
        if (modelFactory != null) {
            return JaxbFactory.create(crestConfig, source, modelFactory);
        }
        return new TypeCachingJaxb(crestConfig, source);
    }

    static Jaxb create(CRestConfig crestConfig, Class<?> source, String context) throws JAXBException {
        return JaxbFactory.create(crestConfig, source, JAXBContext.newInstance((String)context));
    }

    static Jaxb create(CRestConfig crestConfig, Class<?> source, Class<?> ... classToBeBound) throws JAXBException {
        return JaxbFactory.create(crestConfig, source, JAXBContext.newInstance((Class[])classToBeBound));
    }

    private static Jaxb create(CRestConfig crestConfig, Class<?> source, JAXBContext jaxb) throws JAXBException {
        int poolSize = crestConfig.getConcurrencyLevel();
        if (poolSize == 1) {
            return new SimpleJaxb(jaxb);
        }
        String prefix = source.getName();
        long maxWait = crestConfig.get(prefix + POOL_RETRIEVAL_MAX_WAIT, DEFAULT_MAX_WAIT);
        return new PooledJaxb(jaxb, poolSize, maxWait);
    }
}

