/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.Map;
import org.codegist.crest.CRestConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JacksonFactory {
    static final String JACKSON_OBJECT_MAPPER = "#user-object-mapper";
    static final String JACKSON_DESERIALIZER_CONFIG = "#deserializer-config";
    static final String JACKSON_SERIALIZER_CONFIG = "#serializer-config";
    private static final Map<SerializationFeature, Boolean> DEFAULT_SERIALIZER_CONFIG = new HashMap<SerializationFeature, Boolean>();
    private static final Map<DeserializationFeature, Boolean> DEFAULT_DESERIALIZER_CONFIG = new HashMap<DeserializationFeature, Boolean>();

    private JacksonFactory() {
        throw new IllegalStateException();
    }

    static ObjectMapper createObjectMapper(CRestConfig crestConfig, Class<?> source) {
        String prefix = source.getName();
        ObjectMapper mapper = (ObjectMapper)crestConfig.get(prefix + JACKSON_OBJECT_MAPPER);
        if (mapper != null) {
            return mapper;
        }
        mapper = new ObjectMapper();
        Map<DeserializationFeature, Boolean> deserConfig = crestConfig.get(prefix + JACKSON_DESERIALIZER_CONFIG, DEFAULT_DESERIALIZER_CONFIG);
        for (Map.Entry<DeserializationFeature, Boolean> feature : deserConfig.entrySet()) {
            mapper.configure(feature.getKey(), feature.getValue().booleanValue());
        }
        Map<SerializationFeature, Boolean> serConfig = crestConfig.get(prefix + JACKSON_SERIALIZER_CONFIG, DEFAULT_SERIALIZER_CONFIG);
        for (Map.Entry<SerializationFeature, Boolean> feature : serConfig.entrySet()) {
            mapper.configure(feature.getKey(), feature.getValue().booleanValue());
        }
        return mapper;
    }

    static {
        DEFAULT_DESERIALIZER_CONFIG.put(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

