/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.codegist.common.io.IOs;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.jackson.JacksonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonDeserializer
implements Deserializer {
    private static final String PREFIX = JacksonDeserializer.class.getName();
    public static final String OBJECT_MAPPER_PROP = PREFIX + "#user-object-mapper";
    public static final String JACKSON_DESERIALIZER_CONFIG_PROP = PREFIX + "#deserializer-config";
    private final ObjectMapper jackson;

    public JacksonDeserializer(CRestConfig crestConfig) {
        this.jackson = JacksonFactory.createObjectMapper(crestConfig, this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> type, Type genericType, InputStream stream, Charset charset) throws IOException {
        try {
            Object object = this.jackson.readValue((Reader)new InputStreamReader(stream, charset), this.jackson.getTypeFactory().constructType(genericType));
            return (T)object;
        }
        finally {
            IOs.close(stream);
        }
    }
}

