/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer;

import org.codegist.common.log.Logger;
import org.codegist.crest.CRestException;
import org.codegist.crest.io.Response;
import org.codegist.crest.serializer.ResponseDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDeserializerComposite
implements ResponseDeserializer {
    private static final Logger LOG = Logger.getLogger(ResponseDeserializer.class);
    private final ResponseDeserializer[] delegates;

    public ResponseDeserializerComposite(ResponseDeserializer ... delegates) {
        this.delegates = (ResponseDeserializer[])delegates.clone();
    }

    @Override
    public <T> T deserialize(Response response) throws Exception {
        Throwable deserializationException = null;
        for (ResponseDeserializer deserializer : this.delegates) {
            try {
                return deserializer.deserialize(response);
            }
            catch (IllegalArgumentException e) {
                LOG.trace("Deserializer %s can't handle response, trying with next one", deserializer);
                deserializationException = e;
            }
        }
        LOG.debug(deserializationException, "Cannot deserialize response with given deserialize list: %s. Last exception: %s", this.delegates, deserializationException.getMessage());
        throw new CRestException(deserializationException.getMessage(), deserializationException);
    }
}

