/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer;

import org.codegist.common.lang.Validate;
import org.codegist.common.log.Logger;
import org.codegist.crest.io.Response;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.ResponseDeserializer;
import org.codegist.crest.util.ComponentRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDeserializerByMimeType
implements ResponseDeserializer {
    private static final String MIME_TYPE_NOT_FOUND_ERROR = "Cannot deserialize response to response's mimeType '%s', cancelling deserialization.\n" + "CRest has a predefined list of 'known' mime-type for common data type (ei:xml, json, plaintext). " + "If the server response if effectively one of these common types, but not part of CRest's default mime type lists, then you can build a CRest instance of follow:\n\n" + "  CRest crest = new CRestBuilder().bindJsonDeserializerWith(\"server-given-mime-type\").build();\n" + "or\n" + "  CRest crest = new CRestBuilder().bindXmlDeserializerWith(\"server-given-mime-type\").build();\n" + "or\n" + "  CRest crest = new CRestBuilder().bindPlainTextDeserializerWith(\"server-given-mime-type\").build();\n\n" + "This will add \"server-given-mime-type\" mime type to the prefedined list of common mime for the respective deserializer.\n" + "Otherwise, if the mime type represent a custom type, then you can write your own deserializer and bind it as follow:\n\n" + "  CRest crest = new CRestBuilder().bindDeserializer(MyOwnTypeDeserializer.class, \"server-given-mime-type\").build();";
    private static final Logger LOG = Logger.getLogger(ResponseDeserializerByMimeType.class);
    private final ComponentRegistry<String, Deserializer> mimeDeserializerRegistry;

    public ResponseDeserializerByMimeType(ComponentRegistry<String, Deserializer> mimeDeserializerRegistry) {
        this.mimeDeserializerRegistry = mimeDeserializerRegistry;
    }

    @Override
    public <T> T deserialize(Response response) throws Exception {
        String mimeType = response.getContentType();
        Validate.isTrue(this.mimeDeserializerRegistry.contains(mimeType), MIME_TYPE_NOT_FOUND_ERROR, mimeType);
        LOG.debug("Trying to deserialize response to Mime Type: %s.", mimeType);
        return (T)this.mimeDeserializerRegistry.get(mimeType).deserialize(response.getExpectedType(), response.getExpectedGenericType(), response.asStream(), response.getCharset());
    }
}

