/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.codegist.common.io.IOs;
import org.codegist.common.lang.Validate;
import org.codegist.common.log.Logger;
import org.codegist.crest.CRestException;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.io.Response;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.ResponseDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDeserializerByDeserializers
implements ResponseDeserializer {
    private static final Logger LOG = Logger.getLogger(ResponseDeserializerByDeserializers.class);
    private static final String NO_DESERIALIZERS_ERROR = "No deserializers have been configured for the method config (%s), cancelling deserialization.\n" + "This happens after both response's Content-Type and method's return type based deserializations have failed deserializing the response.\n" + "As a last attempt, CRest will try to use the predefined deserializer for the method, defined using @Consumes(\"some-mime-type\") or @Deserializer(MyDeserializer.class) annotations. " + "If not present, then deserialization is not possible at this point.\n" + "To fix it, try one of the following:\n" + "  - Ensure the response has a known Content-Type.\n" + "  - If response Content-Type is unknown, bind it through CRestBuilder using either a common deserializer or providing your own.\n" + "  - If response Content-Type cannot be changed, bind a deserializer either through @Consumes(\"some-mime-type\") or @Deserializer(MyDeserializer.class) annotation.";

    @Override
    public <T> T deserialize(Response response) throws Exception {
        boolean isDumped;
        MethodConfig mc = response.getRequest().getMethodConfig();
        Object[] deserializers = mc.getDeserializers();
        Validate.isTrue(deserializers.length > 0, NO_DESERIALIZERS_ERROR, mc);
        InputStream pStream = response.asStream();
        if (deserializers.length > 1) {
            pStream = new ByteArrayInputStream(IOs.toByteArray(pStream, true));
            isDumped = true;
        } else {
            isDumped = false;
        }
        Exception deserializationException = null;
        for (Deserializer deserializer : deserializers) {
            try {
                LOG.debug("Trying to deserialize response with user specified deserializer: %s.", deserializer);
                return (T)deserializer.deserialize(response.getExpectedType(), response.getExpectedGenericType(), pStream, response.getCharset());
            }
            catch (Exception e) {
                LOG.warn(e, "Failed to deserialize response with user specified deserializer: %s. Trying next.", deserializer);
                deserializationException = e;
                if (!isDumped) continue;
                pStream.mark(0);
                pStream.reset();
            }
        }
        throw new CRestException("Could not deserialize response with given deserializers " + Arrays.toString(deserializers), deserializationException);
    }
}

