/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.serializer;

import org.codegist.common.lang.Validate;
import org.codegist.common.log.Logger;
import org.codegist.crest.io.Response;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.ResponseDeserializer;
import org.codegist.crest.util.ComponentRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDeserializerByClass
implements ResponseDeserializer {
    private static final String CLASS_NOT_FOUND_ERROR = "Cannot deserialize response to class '%s', cancelling deserialization.\n" + "This happens after response's Content-Type based deserialization have failed deserializing the response because of an unknown or not present response Content-Type.\n" + "CRest has a predefined list of known classes for common data type (ei:primitives, InputStream, Reader etc...). " + "These deserializers are used when CRest cannot deserialize the response based on the server response's content-type.\n" + "The method return type does not fall in the predefined list of known types. You can write your own deserializer and bind it as follow:\n\n" + "  CRest crest = new CRestBuilder().bindDeserializer(MyOwnTypeDeserializer.class, MyOwnType.class).build();\n" + "or, if the server can provide a Content-Type:\n" + "  CRest crest = new CRestBuilder().bindDeserializer(MyOwnTypeDeserializer.class, \"the-content-type\").build();";
    private static final Logger LOG = Logger.getLogger(ResponseDeserializerByClass.class);
    private final ComponentRegistry<Class<?>, Deserializer> classDeserializerRegistry;

    public ResponseDeserializerByClass(ComponentRegistry<Class<?>, Deserializer> classDeserializerRegistry) {
        this.classDeserializerRegistry = classDeserializerRegistry;
    }

    @Override
    public <T> T deserialize(Response response) throws Exception {
        Class<?> type = response.getExpectedType();
        Validate.isTrue(this.classDeserializerRegistry.contains(type), CLASS_NOT_FOUND_ERROR, type);
        LOG.debug("Trying to deserialize response to Type: %s.", type);
        return (T)this.classDeserializerRegistry.get(type).deserialize(type, response.getExpectedGenericType(), response.asStream(), response.getCharset());
    }
}

