/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.oauth.v1;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.codegist.common.codec.Base64;
import org.codegist.common.log.Logger;
import org.codegist.common.net.Urls;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.security.oauth.OAuthToken;
import org.codegist.crest.security.oauth.v1.VariantProvider;
import org.codegist.crest.util.Pairs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OAuthsV1 {
    static final EncodedPair[] EMPTY_HTTP_PAIRS = new EncodedPair[0];
    private static final Charset ENC = Charset.forName("UTF-8");
    private static final Logger LOGGER = Logger.getLogger(OAuthsV1.class);
    private static final OAuthToken IGNORE_POISON = new OAuthToken("", "");
    private static final String SIGN_METH = "HMAC-SHA1";
    private static final String SIGN_METH_4_J = "HmacSHA1";
    private static final int AFTER_PROTOCOL_INDEX = 8;

    private OAuthsV1() {
        throw new IllegalStateException();
    }

    static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf(63);
        String retVal = url;
        if (-1 != index) {
            retVal = retVal.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = retVal.substring(0, slashIndex = retVal.indexOf(47, 8)).toLowerCase()).indexOf(58, 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        return baseURL + retVal.substring(slashIndex);
    }

    static List<EncodedPair> oauth(VariantProvider variant, OAuthToken consumerOAuthToken, MethodType methodType, String url, EncodedPair[] parameters, EncodedPair ... extrasOAuthParams) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        return OAuthsV1.oauth(variant, consumerOAuthToken, IGNORE_POISON, methodType, url, parameters, extrasOAuthParams);
    }

    static List<EncodedPair> oauth(VariantProvider variant, OAuthToken consumerOAuthToken, OAuthToken accessOAuthToken, MethodType methodType, String url, EncodedPair[] parameters, EncodedPair ... extrasOAuthParams) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        List<EncodedPair> oauthParams = OAuthsV1.oauthParamsFor(variant, consumerOAuthToken, accessOAuthToken, extrasOAuthParams);
        ArrayList<EncodedPair> toSign = new ArrayList<EncodedPair>(oauthParams);
        toSign.addAll(Arrays.asList(parameters));
        String signature = OAuthsV1.sign(consumerOAuthToken, accessOAuthToken, methodType, url, toSign);
        oauthParams.add(OAuthsV1.pair("oauth_signature", signature));
        return oauthParams;
    }

    private static String sign(OAuthToken consumerOAuthToken, OAuthToken accessOAuthToken, MethodType methodType, String url, List<EncodedPair> oauthParams) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        List<EncodedPair> sorted = Pairs.sortByNameAndValues(oauthParams);
        String signUri = OAuthsV1.constructRequestURL(url);
        String signParams = Pairs.join(sorted, '&', '=', false, false);
        String signature = consumerOAuthToken.getSecret() + "&" + accessOAuthToken.getSecret();
        Mac mac = Mac.getInstance(SIGN_METH_4_J);
        mac.init(new SecretKeySpec(signature.getBytes(ENC), SIGN_METH_4_J));
        String data = methodType.name() + "&" + Urls.encode(signUri, ENC) + "&" + Urls.encode(signParams, ENC);
        String encoded = new String(Base64.encodeToByte(mac.doFinal(data.getBytes(ENC))), ENC);
        LOGGER.debug("Signature[data=\"%s\",signature=\"%s\",result=\"%s\"]", data, signature, encoded);
        return encoded;
    }

    private static List<EncodedPair> oauthParamsFor(VariantProvider variant, OAuthToken consumerOAuthToken, OAuthToken accessOAuthToken, EncodedPair ... extras) throws UnsupportedEncodingException {
        ArrayList<EncodedPair> params = new ArrayList<EncodedPair>();
        if (accessOAuthToken != IGNORE_POISON) {
            params.add(OAuthsV1.pair("oauth_token", accessOAuthToken.getToken()));
        }
        params.add(OAuthsV1.pair("oauth_consumer_key", consumerOAuthToken.getToken()));
        params.add(OAuthsV1.pair("oauth_signature_method", SIGN_METH));
        params.add(OAuthsV1.pair("oauth_timestamp", variant.timestamp()));
        params.add(OAuthsV1.pair("oauth_nonce", variant.nonce()));
        params.add(OAuthsV1.pair("oauth_version", "1.0"));
        params.addAll(Arrays.asList(extras));
        return params;
    }

    static EncodedPair pair(String name, String value) throws UnsupportedEncodingException {
        return Pairs.toPair(name, value, ENC);
    }
}

