/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.oauth.v1;

import org.codegist.crest.CRestBuilder;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.io.http.HttpChannelFactory;
import org.codegist.crest.io.http.HttpURLConnectionHttpChannelFactory;
import org.codegist.crest.security.oauth.OAuthToken;
import org.codegist.crest.security.oauth.v1.DefaultVariantProvider;
import org.codegist.crest.security.oauth.v1.FormOAuthInterface;
import org.codegist.crest.security.oauth.v1.OAuthApiV1;
import org.codegist.crest.security.oauth.v1.OAuthInterface;
import org.codegist.crest.security.oauth.v1.QueryOAuthInterface;
import org.codegist.crest.security.oauth.v1.VariantProvider;

public final class OAuthApiV1Builder {
    private final CRestBuilder crestBuilder;
    private final OAuthToken consumerToken;
    private final String oauthEndPoint;
    private VariantProvider variantProvider = DefaultVariantProvider.INSTANCE;
    private HttpChannelFactory channelFactory = new HttpURLConnectionHttpChannelFactory();
    private MethodType methodType = MethodType.POST;
    private Class<? extends OAuthInterface> oauthInterfaceCls = FormOAuthInterface.class;
    private String requestTokenPath = "";
    private String accessTokenPath = "";
    private String refreshAccessTokenPath = "";

    public OAuthApiV1 build() {
        OAuthInterface oauthInterface = this.crestBuilder.placeholder("oauth.end-point", this.oauthEndPoint).placeholder("oauth.access-token.path", this.accessTokenPath).placeholder("oauth.request-token.path", this.requestTokenPath).placeholder("oauth.refresh-access-token.path", this.refreshAccessTokenPath).setHttpChannelFactory(this.channelFactory).build().build(this.oauthInterfaceCls);
        return new OAuthApiV1(this.methodType, this.oauthEndPoint, this.requestTokenPath, this.accessTokenPath, this.refreshAccessTokenPath, oauthInterface, this.consumerToken, this.variantProvider);
    }

    public OAuthApiV1Builder(OAuthToken consumerToken, String oauthEndPoint) {
        this(consumerToken, oauthEndPoint, new CRestBuilder());
    }

    OAuthApiV1Builder(OAuthToken consumerToken, String oauthEndPoint, CRestBuilder crestBuilder) {
        this.consumerToken = consumerToken;
        this.oauthEndPoint = oauthEndPoint;
        this.crestBuilder = crestBuilder;
    }

    public OAuthApiV1Builder getRequestTokenFrom(String path) {
        this.requestTokenPath = path;
        return this;
    }

    public OAuthApiV1Builder getAccessTokenFrom(String path) {
        this.accessTokenPath = path;
        return this;
    }

    public OAuthApiV1Builder refreshAccessTokenFrom(String path) {
        this.refreshAccessTokenPath = path;
        return this;
    }

    public OAuthApiV1Builder useGet() {
        this.methodType = MethodType.GET;
        this.oauthInterfaceCls = QueryOAuthInterface.class;
        return this;
    }

    public OAuthApiV1Builder using(HttpChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public OAuthApiV1Builder using(VariantProvider variantProvider) {
        this.variantProvider = variantProvider;
        return this;
    }
}

