/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.oauth.v1;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.security.oauth.OAuthApi;
import org.codegist.crest.security.oauth.OAuthToken;
import org.codegist.crest.security.oauth.v1.OAuthInterface;
import org.codegist.crest.security.oauth.v1.OAuthsV1;
import org.codegist.crest.security.oauth.v1.VariantProvider;
import org.codegist.crest.util.Pairs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OAuthApiV1
implements OAuthApi {
    private static final EncodedPair CALLBACK = Pairs.toPreEncodedPair("oauth_callback", "oob");
    private final MethodType methodType;
    private final String requestTokenPath;
    private final String accessTokenPath;
    private final String refreshAccessTokenPath;
    private final OAuthToken consumerToken;
    private final OAuthInterface oauthInterface;
    private final VariantProvider variantProvider;

    public OAuthApiV1(MethodType methodType, String oauthEndPoint, String requestTokenPath, String accessTokenPath, String refreshAccessTokenPath, OAuthInterface oauthInterface, OAuthToken consumerToken, VariantProvider variantProvider) {
        this.methodType = methodType;
        this.requestTokenPath = oauthEndPoint + requestTokenPath;
        this.accessTokenPath = oauthEndPoint + accessTokenPath;
        this.refreshAccessTokenPath = oauthEndPoint + refreshAccessTokenPath;
        this.oauthInterface = oauthInterface;
        this.consumerToken = consumerToken;
        this.variantProvider = variantProvider;
    }

    @Override
    public OAuthToken getRequestToken() throws Exception {
        List<EncodedPair> oauthPairs = OAuthsV1.oauth(this.variantProvider, this.consumerToken, this.methodType, this.requestTokenPath, OAuthsV1.EMPTY_HTTP_PAIRS, CALLBACK);
        Map<String, String> params = this.asMap(oauthPairs);
        return this.oauthInterface.getRequestToken(params.get("oauth_consumer_key"), params.get("oauth_signature_method"), params.get("oauth_timestamp"), params.get("oauth_nonce"), params.get("oauth_version"), params.get("oauth_callback"), params.get("oauth_signature"));
    }

    @Override
    public OAuthToken getAccessToken(OAuthToken requestOAuthToken, String verifier) throws Exception {
        List<EncodedPair> oauthPairs = OAuthsV1.oauth(this.variantProvider, requestOAuthToken, this.methodType, this.accessTokenPath, OAuthsV1.EMPTY_HTTP_PAIRS, OAuthsV1.pair("oauth_verifier", verifier));
        Map<String, String> params = this.asMap(oauthPairs);
        return this.oauthInterface.getAccessToken(params.get("oauth_consumer_key"), params.get("oauth_signature_method"), params.get("oauth_timestamp"), params.get("oauth_nonce"), params.get("oauth_version"), params.get("oauth_verifier"), params.get("oauth_signature"));
    }

    @Override
    public OAuthToken refreshAccessToken(OAuthToken token) throws Exception {
        List<EncodedPair> oauthPairs = OAuthsV1.oauth(this.variantProvider, this.consumerToken, token, this.methodType, this.refreshAccessTokenPath, OAuthsV1.EMPTY_HTTP_PAIRS, token.getAttribute("oauth_session_handle"));
        Map<String, String> params = this.asMap(oauthPairs);
        return this.oauthInterface.refreshAccessToken(params.get("oauth_token"), params.get("oauth_consumer_key"), params.get("oauth_signature_method"), params.get("oauth_timestamp"), params.get("oauth_nonce"), params.get("oauth_version"), params.get("oauth_session_handle"), params.get("oauth_signature"));
    }

    private Map<String, String> asMap(List<EncodedPair> pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (EncodedPair pair : pairs) {
            map.put(pair.getName(), pair.getValue());
        }
        return map;
    }
}

